/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.discovery.eureka;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.MyDataCenterInstanceConfig;
import com.netflix.appinfo.providers.EurekaConfigBasedInstanceInfoProvider;
import com.netflix.config.ConfigurationManager;
import com.netflix.discovery.DefaultEurekaClientConfig;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.transport.jersey.TransportClientFactories;
import com.netflix.discovery.shared.transport.jersey3.Jersey3TransportClientFactories;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.shenyu.common.concurrent.ShenyuThreadFactory;
import org.apache.shenyu.common.dto.DiscoveryUpstreamData;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.discovery.api.ShenyuDiscoveryService;
import org.apache.shenyu.discovery.api.config.DiscoveryConfig;
import org.apache.shenyu.discovery.api.listener.DataChangedEventListener;
import org.apache.shenyu.discovery.api.listener.DiscoveryDataChangedEvent;
import org.apache.shenyu.discovery.eureka.CustomedEurekaConfig;
import org.apache.shenyu.spi.Join;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Join
public class EurekaDiscoveryService
implements ShenyuDiscoveryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EurekaDiscoveryService.class);
    private ApplicationInfoManager applicationInfoManager;
    private EurekaClient eurekaClient;
    private DiscoveryConfig discoveryConfig;
    private final ScheduledExecutorService executorService = new ScheduledThreadPoolExecutor(10, ShenyuThreadFactory.create((String)"scheduled-eureka-watcher", (boolean)true));
    private final ConcurrentMap<String, ScheduledFuture<?>> listenerThreadsMap = new ConcurrentHashMap();
    private final ConcurrentMap<String, List<InstanceInfo>> instanceListMap = new ConcurrentHashMap<String, List<InstanceInfo>>();

    public void init(DiscoveryConfig config) {
        if (this.eurekaClient != null) {
            LOGGER.info("Eureka naming service already registered");
        }
        this.discoveryConfig = config;
        try {
            ConfigurationManager.loadProperties((Properties)this.getEurekaProperties(false));
            this.applicationInfoManager = this.initializeApplicationInfoManager((EurekaInstanceConfig)new MyDataCenterInstanceConfig());
            this.eurekaClient = this.initializeEurekaClient(this.applicationInfoManager, (EurekaClientConfig)new DefaultEurekaClientConfig());
            LOGGER.info("Initializing EurekaDiscoveryService success");
        }
        catch (Exception e) {
            LOGGER.error("Error initializing EurekaDiscoveryService", (Throwable)e);
            this.clean();
            throw new ShenyuException((Throwable)e);
        }
    }

    public void watch(String key, DataChangedEventListener listener) {
        List initialInstances = this.eurekaClient.getInstancesByVipAddressAndAppName(null, key, true);
        this.instanceListMap.put(key, initialInstances);
        for (InstanceInfo instance : initialInstances) {
            DiscoveryDataChangedEvent dataChangedEvent = new DiscoveryDataChangedEvent(instance.getAppName(), this.buildUpstreamJsonFromInstanceInfo(instance), DiscoveryDataChangedEvent.Event.ADDED);
            listener.onChange(dataChangedEvent);
        }
        ScheduledFuture<?> scheduledFuture = this.executorService.scheduleAtFixedRate(() -> {
            try {
                List previousInstances = (List)this.instanceListMap.get(key);
                List currentInstances = this.eurekaClient.getInstancesByVipAddressAndAppName(null, key, true);
                this.compareInstances(previousInstances, currentInstances, listener);
                this.instanceListMap.put(key, currentInstances);
            }
            catch (Exception e) {
                LOGGER.error("EurekaDiscoveryService watch key: {} error", (Object)key, (Object)e);
                throw new ShenyuException((Throwable)e);
            }
        }, 0L, 1L, TimeUnit.SECONDS);
        this.listenerThreadsMap.put(key, scheduledFuture);
    }

    public void unwatch(String key) {
        try {
            ScheduledFuture scheduledFuture = (ScheduledFuture)this.listenerThreadsMap.get(key);
            if (Objects.nonNull(scheduledFuture)) {
                scheduledFuture.cancel(true);
                this.listenerThreadsMap.remove(key);
                LOGGER.info("EurekaDiscoveryService unwatch key {} successfully", (Object)key);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error removing eureka watch task for key '{}': {}", new Object[]{key, e.getMessage(), e});
            throw new ShenyuException((Throwable)e);
        }
    }

    public void register(String key, String value) {
        CustomedEurekaConfig customedEurekaConfig = new CustomedEurekaConfig();
        InstanceInfo instanceInfoFromJson = this.buildInstanceInfoFromUpstream(key, value);
        customedEurekaConfig.setIpAddress(instanceInfoFromJson.getIPAddr());
        customedEurekaConfig.setPort(instanceInfoFromJson.getPort());
        customedEurekaConfig.setApplicationName(key);
        customedEurekaConfig.setInstanceId(instanceInfoFromJson.getInstanceId());
        customedEurekaConfig.setMetadataMap(instanceInfoFromJson.getMetadata());
        try {
            ConfigurationManager.loadProperties((Properties)this.getEurekaProperties(true));
            InstanceInfo instanceInfo = new EurekaConfigBasedInstanceInfoProvider((EurekaInstanceConfig)customedEurekaConfig).get();
            this.applicationInfoManager = new ApplicationInfoManager((EurekaInstanceConfig)customedEurekaConfig, instanceInfo);
            this.eurekaClient = new DiscoveryClient(this.applicationInfoManager, (EurekaClientConfig)new DefaultEurekaClientConfig(), (TransportClientFactories)new Jersey3TransportClientFactories());
            this.applicationInfoManager.setInstanceStatus(InstanceInfo.InstanceStatus.UP);
        }
        catch (Exception e) {
            LOGGER.error("Error register eureka instance", (Throwable)e);
            this.clean();
            throw new ShenyuException((Throwable)e);
        }
    }

    public List<String> getRegisterData(String key) {
        try {
            List instances = this.eurekaClient.getInstancesByVipAddressAndAppName(null, key, true);
            ArrayList<String> registerDataList = new ArrayList<String>();
            for (InstanceInfo instanceInfo : instances) {
                String instanceInfoJson = this.buildUpstreamJsonFromInstanceInfo(instanceInfo);
                registerDataList.add(instanceInfoJson);
            }
            return registerDataList;
        }
        catch (Exception e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    public Boolean exists(String key) {
        try {
            List instances = this.eurekaClient.getInstancesByVipAddressAndAppName(null, key, true);
            return !instances.isEmpty();
        }
        catch (Exception e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    public void shutdown() {
        try {
            for (ScheduledFuture scheduledFuture : this.listenerThreadsMap.values()) {
                scheduledFuture.cancel(true);
            }
            this.listenerThreadsMap.clear();
            if (Objects.nonNull(this.eurekaClient)) {
                this.eurekaClient.getApplicationInfoManager().setInstanceStatus(InstanceInfo.InstanceStatus.DOWN);
                this.eurekaClient.shutdown();
            }
            LOGGER.info("Shutting down EurekaDiscoveryService");
            this.clean();
        }
        catch (Exception e) {
            LOGGER.error("Shutting down EurekaDiscoveryService error", (Throwable)e);
            throw new ShenyuException((Throwable)e);
        }
    }

    private Properties getEurekaProperties(boolean needRegister) {
        Properties eurekaProperties = new Properties();
        eurekaProperties.setProperty("eureka.serviceUrl.default", this.discoveryConfig.getServerList());
        eurekaProperties.setProperty("eureka.client.refresh.interval", this.discoveryConfig.getProps().getProperty("eurekaClientRefreshInterval", "10"));
        eurekaProperties.setProperty("eureka.client.registry-fetch-interval-seconds", this.discoveryConfig.getProps().getProperty("eurekaClientRegistryFetchIntervalSeconds", "10"));
        eurekaProperties.setProperty("eureka.registration.enabled", String.valueOf(needRegister));
        return eurekaProperties;
    }

    private ApplicationInfoManager initializeApplicationInfoManager(EurekaInstanceConfig instanceConfig) {
        if (Objects.isNull(this.applicationInfoManager)) {
            InstanceInfo instanceInfo = new EurekaConfigBasedInstanceInfoProvider(instanceConfig).get();
            this.applicationInfoManager = new ApplicationInfoManager(instanceConfig, instanceInfo);
        }
        return this.applicationInfoManager;
    }

    private EurekaClient initializeEurekaClient(ApplicationInfoManager applicationInfoManager, EurekaClientConfig clientConfig) {
        if (Objects.isNull(this.eurekaClient)) {
            this.eurekaClient = new DiscoveryClient(applicationInfoManager, clientConfig, (TransportClientFactories)new Jersey3TransportClientFactories());
        }
        return this.eurekaClient;
    }

    private void clean() {
        this.eurekaClient = null;
        this.applicationInfoManager = null;
    }

    private String buildUpstreamJsonFromInstanceInfo(InstanceInfo instanceInfo) {
        JsonObject upstreamJson = new JsonObject();
        upstreamJson.addProperty("url", instanceInfo.getIPAddr() + ":" + instanceInfo.getPort());
        upstreamJson.addProperty("weight", (String)instanceInfo.getMetadata().get("weight"));
        upstreamJson.addProperty("protocol", (String)instanceInfo.getMetadata().get("protocol"));
        upstreamJson.addProperty("props", (String)instanceInfo.getMetadata().get("props"));
        if (instanceInfo.getStatus() == InstanceInfo.InstanceStatus.UP) {
            upstreamJson.addProperty("status", (Number)0);
        } else if (instanceInfo.getStatus() == InstanceInfo.InstanceStatus.DOWN) {
            upstreamJson.addProperty("status", (Number)1);
        }
        return GsonUtils.getInstance().toJson((Object)upstreamJson);
    }

    private void compareInstances(List<InstanceInfo> previousInstances, List<InstanceInfo> currentInstances, DataChangedEventListener listener) {
        Set updatedInstances;
        Set deletedInstances;
        Set addedInstances = currentInstances.stream().filter(item -> !previousInstances.contains(item)).collect(Collectors.toSet());
        if (!addedInstances.isEmpty()) {
            for (Object instance : addedInstances) {
                DiscoveryDataChangedEvent dataChangedEvent = new DiscoveryDataChangedEvent(instance.getAppName(), this.buildUpstreamJsonFromInstanceInfo((InstanceInfo)instance), DiscoveryDataChangedEvent.Event.ADDED);
                listener.onChange(dataChangedEvent);
            }
        }
        if (!(deletedInstances = previousInstances.stream().filter(item -> !currentInstances.contains(item)).collect(Collectors.toSet())).isEmpty()) {
            for (InstanceInfo instance : deletedInstances) {
                instance.setStatus(InstanceInfo.InstanceStatus.DOWN);
                DiscoveryDataChangedEvent dataChangedEvent = new DiscoveryDataChangedEvent(instance.getAppName(), this.buildUpstreamJsonFromInstanceInfo(instance), DiscoveryDataChangedEvent.Event.DELETED);
                listener.onChange(dataChangedEvent);
            }
        }
        if (!(updatedInstances = currentInstances.stream().filter(currentInstance -> previousInstances.stream().anyMatch(previousInstance -> currentInstance.getInstanceId().equals(previousInstance.getInstanceId()) && !currentInstance.equals(previousInstance))).collect(Collectors.toSet())).isEmpty()) {
            for (InstanceInfo instance : updatedInstances) {
                DiscoveryDataChangedEvent dataChangedEvent = new DiscoveryDataChangedEvent(instance.getAppName(), this.buildUpstreamJsonFromInstanceInfo(instance), DiscoveryDataChangedEvent.Event.UPDATED);
                listener.onChange(dataChangedEvent);
            }
        }
    }

    private InstanceInfo buildInstanceInfoFromUpstream(String key, String value) {
        try {
            DiscoveryUpstreamData upstreamData = (DiscoveryUpstreamData)GsonUtils.getInstance().fromJson(value, DiscoveryUpstreamData.class);
            Map metadata = GsonUtils.getInstance().toObjectMap(upstreamData.getProps(), String.class);
            metadata = metadata != null ? metadata : new HashMap();
            metadata.put("weight", String.valueOf(upstreamData.getWeight()));
            metadata.put("protocol", String.valueOf(upstreamData.getProtocol()));
            metadata.put("props", Optional.ofNullable(upstreamData.getProps()).orElse("{}"));
            String[] urls = upstreamData.getUrl().split(":", 2);
            return InstanceInfo.Builder.newBuilder().setAppName(key).setIPAddr(urls[0]).setPort(Integer.parseInt(urls[1])).setMetadata(metadata).setInstanceId(urls[0] + ":" + key + ":" + urls[1]).build();
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            LOGGER.error("The json format of value is wrong: {}", (Object)jsonSyntaxException.getMessage(), (Object)jsonSyntaxException);
            throw new ShenyuException((Throwable)jsonSyntaxException);
        }
    }
}

