/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.cls.producer.common;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.tencentcloudapi.cls.producer.common.SendProducerBatchTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class SendThreadPool {
    private static final String SEND_THREAD_SUFFIX_FORMAT = "-send-thread-%d";
    private final ExecutorService sendThreadPool;

    public SendThreadPool(int threadCount, String prefix) {
        this.sendThreadPool = Executors.newFixedThreadPool(threadCount, new ThreadFactoryBuilder().setDaemon(true).setNameFormat(prefix + SEND_THREAD_SUFFIX_FORMAT).build());
    }

    public void submit(SendProducerBatchTask task) {
        this.sendThreadPool.submit(task);
    }

    public void shutdown() {
        this.sendThreadPool.shutdown();
    }

    public boolean isTerminated() {
        return this.sendThreadPool.isTerminated();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.sendThreadPool.awaitTermination(timeout, unit);
    }
}

