/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.util;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class MethodUtil {
    private static final Map<Method, String> methodNameMap = new ConcurrentHashMap<Method, String>();
    private static final Object LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String resolveMethodName(Method method) {
        if (method == null) {
            throw new IllegalArgumentException("Null method");
        }
        String methodName = methodNameMap.get(method);
        if (methodName == null) {
            Object object = LOCK;
            synchronized (object) {
                methodName = methodNameMap.get(method);
                if (methodName == null) {
                    StringBuilder sb = new StringBuilder();
                    String className = method.getDeclaringClass().getName();
                    String name = method.getName();
                    Class<?>[] params = method.getParameterTypes();
                    sb.append(className).append(":").append(name);
                    sb.append("(");
                    int paramPos = 0;
                    for (Class<?> clazz : params) {
                        sb.append(clazz.getCanonicalName());
                        if (++paramPos >= params.length) continue;
                        sb.append(",");
                    }
                    sb.append(")");
                    methodName = sb.toString();
                    methodNameMap.put(method, methodName);
                }
            }
        }
        return methodName;
    }

    static void clearMethodMap() {
        methodNameMap.clear();
    }
}

