/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command.impl;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.qos.api.BaseCommand;
import org.apache.dubbo.qos.api.Cmd;
import org.apache.dubbo.qos.api.CommandContext;
import org.apache.dubbo.qos.command.util.CommandHelper;
import org.apache.dubbo.qos.textui.TTable;
import org.apache.dubbo.rpc.model.FrameworkModel;

@Cmd(name="help", summary="help command", example={"help", "help online"})
public class Help
implements BaseCommand {
    private final CommandHelper commandHelper;
    private static final String MAIN_HELP = "mainHelp";
    private static final Map<String, String> processedTable = new WeakHashMap<String, String>();

    public Help(FrameworkModel frameworkModel) {
        this.commandHelper = new CommandHelper(frameworkModel);
    }

    @Override
    public String execute(CommandContext commandContext, String[] args) {
        if (ArrayUtils.isNotEmpty(args)) {
            return processedTable.computeIfAbsent(args[0], this::commandHelp);
        }
        return processedTable.computeIfAbsent(MAIN_HELP, commandName -> this.mainHelp());
    }

    private String commandHelp(String commandName) {
        if (!this.commandHelper.hasCommand(commandName)) {
            return "no such command:" + commandName;
        }
        Class<?> clazz = this.commandHelper.getCommandClass(commandName);
        Cmd cmd = clazz.getAnnotation(Cmd.class);
        TTable tTable = new TTable(new TTable.ColumnDefine[]{new TTable.ColumnDefine(TTable.Align.RIGHT), new TTable.ColumnDefine(80, false, TTable.Align.LEFT)});
        tTable.addRow("COMMAND NAME", commandName);
        if (null != cmd.example()) {
            tTable.addRow("EXAMPLE", this.drawExample(cmd));
        }
        return tTable.padding(1).rendering();
    }

    private String drawExample(Cmd cmd) {
        StringBuilder drawExampleStringBuilder = new StringBuilder();
        for (String example : cmd.example()) {
            drawExampleStringBuilder.append(example).append('\n');
        }
        return drawExampleStringBuilder.toString();
    }

    private String mainHelp() {
        TTable tTable = new TTable(new TTable.ColumnDefine[]{new TTable.ColumnDefine(TTable.Align.RIGHT), new TTable.ColumnDefine(80, false, TTable.Align.LEFT)});
        List<Class<?>> classes = this.commandHelper.getAllCommandClass();
        Collections.sort(classes, new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> o1, Class<?> o2) {
                Integer o1s = o1.getAnnotation(Cmd.class).sort();
                Integer o2s = o2.getAnnotation(Cmd.class).sort();
                return o1s.compareTo(o2s);
            }
        });
        for (Class<?> clazz : classes) {
            if (!clazz.isAnnotationPresent(Cmd.class)) continue;
            Cmd cmd = clazz.getAnnotation(Cmd.class);
            tTable.addRow(cmd.name(), cmd.summary());
        }
        return tTable.padding(1).rendering();
    }
}

