/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.ai.common.strategy.openai;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.JsonUtils;
import org.apache.shenyu.plugin.ai.common.config.AiCommonConfig;
import org.apache.shenyu.plugin.ai.common.strategy.AiModel;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.exception.ResponsiveException;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.base.utils.ServerWebExchangeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class OpenAI
implements AiModel {
    private static final Logger LOG = LoggerFactory.getLogger(OpenAI.class);

    @Override
    public Mono<Void> invoke(AiCommonConfig aiCommonConfig, ServerWebExchange exchange, ShenyuPluginChain chain, List<HttpMessageReader<?>> messageReaders) {
        ServerWebExchange modifiedExchange = exchange.mutate().request(originalRequest -> originalRequest.headers(httpHeaders -> OpenAI.convertHeader(httpHeaders, aiCommonConfig)).method(exchange.getRequest().getMethod())).build();
        return ServerWebExchangeUtils.rewriteRequestBody((ServerWebExchange)modifiedExchange, messageReaders, originalBody -> Mono.just((Object)this.convertBody((String)originalBody, aiCommonConfig))).flatMap(arg_0 -> ((ShenyuPluginChain)chain).execute(arg_0)).onErrorResume(error -> {
            if (error instanceof ResponsiveException) {
                return WebFluxResultUtils.failedResult((ResponsiveException)((ResponsiveException)error));
            }
            return Mono.error((Throwable)error);
        });
    }

    @Override
    public Long getCompletionTokens(String responseBody) {
        try {
            JsonNode totalTokens;
            JsonNode root = JsonUtils.toJsonNode((String)responseBody);
            JsonNode usage = root.get("usage");
            if (Objects.nonNull(usage) && Objects.nonNull(totalTokens = usage.get("completion_tokens"))) {
                return totalTokens.asLong();
            }
        }
        catch (Exception e) {
            LOG.error("Failed to parse response body: {}", (Object)responseBody, (Object)e);
        }
        return 0L;
    }

    private static void convertHeader(HttpHeaders httpHeaders, AiCommonConfig aiCommonConfig) {
        if (!httpHeaders.containsKey((Object)"Authorization")) {
            httpHeaders.add("Authorization", "Bearer " + aiCommonConfig.getApiKey());
        }
        if (aiCommonConfig.getStream().booleanValue()) {
            httpHeaders.add("Content-Type", "text/event-stream");
            httpHeaders.add("Cache-Control", "no-cache");
            httpHeaders.add("Connection", "keep-alive");
        }
    }

    private String convertBody(String originalBody, AiCommonConfig aiCommonConfig) {
        Map requestBodyMap = GsonUtils.getInstance().convertToMap(originalBody);
        requestBodyMap.put("model", aiCommonConfig.getModel());
        requestBodyMap.put("stream", aiCommonConfig.getStream());
        return GsonUtils.getInstance().toJson((Object)requestBodyMap);
    }
}

