/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.api.plugin.circuitbreaker;

import com.tencent.polaris.api.pojo.CircuitBreakerStatus;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.StatusDimension;
import com.tencent.polaris.api.pojo.Subset;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class CircuitBreakResult {
    private final long createTimeMs;
    private final int maxRequestCountAfterHalfOpen;
    private final Map<CircuitBreakerStatus.Status, Map<ResultKey, Instance>> instanceResult = new HashMap<CircuitBreakerStatus.Status, Map<ResultKey, Instance>>();
    private final Map<CircuitBreakerStatus.Status, Map<ResultKey, Subset>> subsetResult = new HashMap<CircuitBreakerStatus.Status, Map<ResultKey, Subset>>();

    public CircuitBreakResult(long createTimeMs, int maxRequestCountAfterHalfOpen) {
        this.createTimeMs = createTimeMs;
        this.maxRequestCountAfterHalfOpen = maxRequestCountAfterHalfOpen;
        this.instanceResult.put(CircuitBreakerStatus.Status.CLOSE, new HashMap());
        this.instanceResult.put(CircuitBreakerStatus.Status.HALF_OPEN, new HashMap());
        this.instanceResult.put(CircuitBreakerStatus.Status.OPEN, new HashMap());
        this.subsetResult.put(CircuitBreakerStatus.Status.CLOSE, new HashMap());
        this.subsetResult.put(CircuitBreakerStatus.Status.HALF_OPEN, new HashMap());
        this.subsetResult.put(CircuitBreakerStatus.Status.OPEN, new HashMap());
    }

    public boolean isEmptyResult() {
        for (Map.Entry<CircuitBreakerStatus.Status, Map<ResultKey, Instance>> entry : this.instanceResult.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            return false;
        }
        for (Map.Entry<CircuitBreakerStatus.Status, Map<ResultKey, Object>> entry : this.subsetResult.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Map<ResultKey, Instance> getInstancesToOpen() {
        return this.instanceResult.get((Object)CircuitBreakerStatus.Status.OPEN);
    }

    public Map<ResultKey, Instance> getInstancesToHalfOpen() {
        return this.instanceResult.get((Object)CircuitBreakerStatus.Status.HALF_OPEN);
    }

    public Map<ResultKey, Instance> getInstancesToClose() {
        return this.instanceResult.get((Object)CircuitBreakerStatus.Status.CLOSE);
    }

    public Map<ResultKey, Subset> getSubsetsToOpen() {
        return this.subsetResult.get((Object)CircuitBreakerStatus.Status.OPEN);
    }

    public Map<ResultKey, Subset> getSubsetsToHalfOpen() {
        return this.subsetResult.get((Object)CircuitBreakerStatus.Status.HALF_OPEN);
    }

    public Map<ResultKey, Subset> getSubsetsToClose() {
        return this.subsetResult.get((Object)CircuitBreakerStatus.Status.CLOSE);
    }

    public long getCreateTimeMs() {
        return this.createTimeMs;
    }

    public int getMaxRequestCountAfterHalfOpen() {
        return this.maxRequestCountAfterHalfOpen;
    }

    public String toString() {
        return "CircuitBreakResult{result=" + this.instanceResult + '}';
    }

    public static class ResultKey {
        private final String instId;
        private final StatusDimension statusDimension;

        public ResultKey(String instId, StatusDimension statusDimension) {
            this.instId = instId;
            this.statusDimension = statusDimension;
        }

        public String getInstId() {
            return this.instId;
        }

        public StatusDimension getStatusDimension() {
            return this.statusDimension;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResultKey resultKey = (ResultKey)o;
            return Objects.equals(this.instId, resultKey.instId) && Objects.equals(this.statusDimension, resultKey.statusDimension);
        }

        public int hashCode() {
            return Objects.hash(this.instId, this.statusDimension);
        }
    }
}

