/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.metric;

import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.metric.HystrixEvent;
import rx.functions.Func1;

public abstract class HystrixCommandEvent
implements HystrixEvent {
    private final HystrixCommandKey commandKey;
    private final HystrixThreadPoolKey threadPoolKey;
    public static final Func1<HystrixCommandEvent, Boolean> filterCompletionsOnly = new Func1<HystrixCommandEvent, Boolean>(){

        public Boolean call(HystrixCommandEvent commandEvent) {
            return commandEvent.isCommandCompletion();
        }
    };
    public static final Func1<HystrixCommandEvent, Boolean> filterActualExecutions = new Func1<HystrixCommandEvent, Boolean>(){

        public Boolean call(HystrixCommandEvent commandEvent) {
            return commandEvent.didCommandExecute();
        }
    };

    protected HystrixCommandEvent(HystrixCommandKey commandKey, HystrixThreadPoolKey threadPoolKey) {
        this.commandKey = commandKey;
        this.threadPoolKey = threadPoolKey;
    }

    public HystrixCommandKey getCommandKey() {
        return this.commandKey;
    }

    public HystrixThreadPoolKey getThreadPoolKey() {
        return this.threadPoolKey;
    }

    public abstract boolean isExecutionStart();

    public abstract boolean isExecutedInThread();

    public abstract boolean isResponseThreadPoolRejected();

    public abstract boolean isCommandCompletion();

    public abstract boolean didCommandExecute();
}

