/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.bootstrap;

import com.alipay.sofa.rpc.bootstrap.ConsumerBootstrap;
import com.alipay.sofa.rpc.bootstrap.ProviderBootstrap;
import com.alipay.sofa.rpc.common.RpcConfigs;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.ext.ExtensionClass;
import com.alipay.sofa.rpc.ext.ExtensionLoader;
import com.alipay.sofa.rpc.ext.ExtensionLoaderFactory;

public class Bootstraps {
    public static <T> ProviderBootstrap<T> from(ProviderConfig<T> providerConfig) {
        String bootstrap = providerConfig.getBootstrap();
        if (StringUtils.isEmpty(bootstrap)) {
            bootstrap = RpcConfigs.getStringValue("default.provider.bootstrap");
            providerConfig.setBootstrap(bootstrap);
        }
        ProviderBootstrap providerBootstrap = ExtensionLoaderFactory.getExtensionLoader(ProviderBootstrap.class).getExtension(bootstrap, new Class[]{ProviderConfig.class}, new Object[]{providerConfig});
        return providerBootstrap;
    }

    public static <T> ConsumerBootstrap<T> from(ConsumerConfig<T> consumerConfig) {
        ConsumerBootstrap consumerBootstrap;
        String bootstrap = consumerConfig.getBootstrap();
        if (StringUtils.isNotEmpty(bootstrap)) {
            consumerBootstrap = ExtensionLoaderFactory.getExtensionLoader(ConsumerBootstrap.class).getExtension(bootstrap, new Class[]{ConsumerConfig.class}, new Object[]{consumerConfig});
        } else {
            bootstrap = consumerConfig.getProtocol();
            ExtensionLoader<ConsumerBootstrap> extensionLoader = ExtensionLoaderFactory.getExtensionLoader(ConsumerBootstrap.class);
            ExtensionClass<ConsumerBootstrap> extensionClass = extensionLoader.getExtensionClass(bootstrap);
            if (extensionClass == null) {
                bootstrap = RpcConfigs.getStringValue("default.consumer.bootstrap");
                consumerConfig.setBootstrap(bootstrap);
                consumerBootstrap = ExtensionLoaderFactory.getExtensionLoader(ConsumerBootstrap.class).getExtension(bootstrap, new Class[]{ConsumerConfig.class}, new Object[]{consumerConfig});
            } else {
                consumerConfig.setBootstrap(bootstrap);
                consumerBootstrap = extensionClass.getExtInstance(new Class[]{ConsumerConfig.class}, new Object[]{consumerConfig});
            }
        }
        return consumerBootstrap;
    }
}

