/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster;

import io.lettuce.core.cluster.models.partitions.RedisClusterNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;

class PartitionAccessor {
    private final Collection<RedisClusterNode> partitions;

    PartitionAccessor(Collection<RedisClusterNode> partitions) {
        this.partitions = partitions;
    }

    List<RedisClusterNode> getUpstream() {
        return this.get(redisClusterNode -> redisClusterNode.is(RedisClusterNode.NodeFlag.UPSTREAM));
    }

    List<RedisClusterNode> getReadCandidates(RedisClusterNode upstream) {
        return this.get(redisClusterNode -> redisClusterNode.getNodeId().equals(upstream.getNodeId()) || redisClusterNode.is(RedisClusterNode.NodeFlag.REPLICA) && upstream.getNodeId().equals(redisClusterNode.getSlaveOf()));
    }

    List<RedisClusterNode> get(Predicate<RedisClusterNode> test) {
        ArrayList<RedisClusterNode> result = new ArrayList<RedisClusterNode>(this.partitions.size());
        for (RedisClusterNode partition : this.partitions) {
            if (!test.test(partition)) continue;
            result.add(partition);
        }
        return result;
    }
}

