/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.ArrayList;
import java.util.List;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.lang.Nullable;
import redis.clients.jedis.util.SafeEncoder;

public class JedisScriptReturnConverter
implements Converter<Object, Object> {
    private final ReturnType returnType;

    public JedisScriptReturnConverter(ReturnType returnType) {
        this.returnType = returnType;
    }

    public Object convert(@Nullable Object result) {
        if (result instanceof String) {
            return SafeEncoder.encode((String)((String)result));
        }
        if (this.returnType == ReturnType.STATUS) {
            return JedisConverters.toString((byte[])result);
        }
        if (this.returnType == ReturnType.BOOLEAN) {
            if (result == null) {
                return Boolean.FALSE;
            }
            return (Long)result == 1L;
        }
        if (this.returnType == ReturnType.MULTI) {
            List resultList = (List)result;
            ArrayList<Object> convertedResults = new ArrayList<Object>();
            for (Object res : resultList) {
                if (res instanceof String) {
                    convertedResults.add(SafeEncoder.encode((String)((String)res)));
                    continue;
                }
                convertedResults.add(res);
            }
            return convertedResults;
        }
        return result;
    }
}

