/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.general.context;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.general.context.handler.GeneralContextPluginDataHandler;
import org.springframework.http.HttpHeaders;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class GeneralContextPlugin
extends AbstractShenyuPlugin {
    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        Map generalContextHandleMap = (Map)GeneralContextPluginDataHandler.CACHED_HANDLE.get().obtainHandle((Object)CacheKeyUtils.INST.getKey(rule));
        HashMap generalContextMap = new HashMap();
        HttpHeaders headers = exchange.getRequest().getHeaders();
        generalContextHandleMap.forEach((rpcType, v) -> {
            if (CollectionUtils.isEmpty((Collection)v)) {
                return;
            }
            HashMap generalContextMapWithRpcType = new HashMap();
            v.forEach(each -> {
                if (StringUtils.isBlank((CharSequence)each.getGeneralContextType()) || StringUtils.isBlank((CharSequence)each.getGeneralContextKey())) {
                    return;
                }
                switch (each.getGeneralContextType()) {
                    case "addGeneralContext": {
                        generalContextMapWithRpcType.put(each.getGeneralContextKey(), each.getGeneralContextValue());
                        break;
                    }
                    case "transmitHeaderToGeneralContext": {
                        List header = headers.get((Object)each.getGeneralContextKey());
                        generalContextMapWithRpcType.put(StringUtils.isBlank((CharSequence)each.getGeneralContextValue()) ? each.getGeneralContextKey() : each.getGeneralContextValue(), CollectionUtils.isEmpty((Collection)header) ? null : String.join((CharSequence)", ", header));
                        break;
                    }
                }
            });
            generalContextMap.put(rpcType, generalContextMapWithRpcType);
        });
        exchange.getAttributes().put("generalContext", generalContextMap);
        return chain.execute(exchange);
    }

    public int getOrder() {
        return PluginEnum.GENERAL_CONTEXT.getCode();
    }

    public String named() {
        return PluginEnum.GENERAL_CONTEXT.getName();
    }

    public boolean skip(ServerWebExchange exchange) {
        return false;
    }
}

