/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.plugin.oauth2;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.oauth2.OAuth2Plugin;
import org.apache.shenyu.plugin.oauth2.filter.OAuth2PreFilter;
import org.apache.shenyu.springboot.starter.plugin.oauth2.DefaultClientsConfiguredCondition;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.reactive.PathRequest;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.config.web.server.SecurityWebFiltersOrder;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.core.userdetails.MapReactiveUserDetailsService;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.InMemoryReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.util.matcher.OrServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.PathPatternParserServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.web.server.WebFilter;

@Configuration
@ConditionalOnClass(value={OAuth2Plugin.class})
@EnableWebFluxSecurity
@ConditionalOnProperty(value={"shenyu.plugins.oauth2.enabled"}, havingValue="true", matchIfMissing=true)
public class OAuth2PluginConfiguration {
    private static final String DEFAULT_CLIENT_REGISTRATION_BEAN = "org.apache.shenyu.springboot.starter.plugin.oauth2.defaultReactiveClientRegistrationRepository";
    private static final List<ServerWebExchangeMatcher> MATCHERS = new CopyOnWriteArrayList<ServerWebExchangeMatcher>();
    private static final OrServerWebExchangeMatcher OR_MATCHER;

    @Bean
    public ShenyuPlugin oAuth2Plugin(ObjectProvider<ReactiveOAuth2AuthorizedClientService> authorizedClientServiceProvider) {
        return new OAuth2Plugin((ReactiveOAuth2AuthorizedClientService)authorizedClientServiceProvider.getObject());
    }

    @Bean
    @ConditionalOnMissingBean(value={ReactiveAuthenticationManager.class})
    MapReactiveUserDetailsService userDetailsService() {
        UserDetails userDetails = User.builder().username("shenyu").password("shenyu").roles(new String[]{"USER"}).disabled(true).build();
        return new MapReactiveUserDetailsService(new UserDetails[]{userDetails});
    }

    @Bean
    public SecurityWebFilterChain getSecurityWebFilterChain(ServerHttpSecurity http, ApplicationContext context) {
        String[] names = context.getBeanNamesForType(ReactiveClientRegistrationRepository.class);
        boolean exists = Arrays.asList(names).contains(DEFAULT_CLIENT_REGISTRATION_BEAN);
        if (exists) {
            return http.csrf().disable().httpBasic().disable().formLogin().disable().authorizeExchange().anyExchange().permitAll().and().build();
        }
        return http.csrf().disable().oauth2Login().and().httpBasic(ServerHttpSecurity.HttpBasicSpec::disable).oauth2Client().and().addFilterAfter((WebFilter)new OAuth2PreFilter(MATCHERS), SecurityWebFiltersOrder.REACTOR_CONTEXT).authorizeExchange(exchanges -> ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)exchanges.matchers(new ServerWebExchangeMatcher[]{PathRequest.toStaticResources().atCommonLocations()})).permitAll().pathMatchers(HttpMethod.OPTIONS)).permitAll().matchers(new ServerWebExchangeMatcher[]{OR_MATCHER})).authenticated().anyExchange().permitAll()).build();
    }

    @Bean(value={"org.apache.shenyu.springboot.starter.plugin.oauth2.defaultReactiveClientRegistrationRepository"})
    @Conditional(value={DefaultClientsConfiguredCondition.class})
    public ReactiveClientRegistrationRepository reactiveClientRegistrationRepository() {
        ClientRegistration.Builder shenyuClientRegistration = ClientRegistration.withRegistrationId((String)"shenyu");
        shenyuClientRegistration.authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE);
        shenyuClientRegistration.tokenUri("/");
        shenyuClientRegistration.authorizationUri("/");
        shenyuClientRegistration.redirectUriTemplate("/");
        shenyuClientRegistration.scope(new String[]{"read:user"});
        shenyuClientRegistration.userInfoUri("/");
        shenyuClientRegistration.clientId("shenyu");
        shenyuClientRegistration.clientSecret("shenyu");
        shenyuClientRegistration.redirectUriTemplate("{baseUrl}/login/oauth2/code/{registrationId}");
        return new InMemoryReactiveClientRegistrationRepository(new ClientRegistration[]{shenyuClientRegistration.build()});
    }

    static {
        MATCHERS.add((ServerWebExchangeMatcher)new PathPatternParserServerWebExchangeMatcher("-"));
        OR_MATCHER = new OrServerWebExchangeMatcher(MATCHERS);
    }
}

