/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sync.data.http;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.concurrent.ShenyuThreadFactory;
import org.apache.shenyu.common.dto.ConfigData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.ThreadUtils;
import org.apache.shenyu.sync.data.api.AuthDataSubscriber;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.apache.shenyu.sync.data.api.SyncDataService;
import org.apache.shenyu.sync.data.http.AccessTokenManager;
import org.apache.shenyu.sync.data.http.config.HttpConfig;
import org.apache.shenyu.sync.data.http.refresh.DataRefreshFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class HttpSyncDataService
implements SyncDataService {
    private static final Logger LOG = LoggerFactory.getLogger(HttpSyncDataService.class);
    private static final AtomicBoolean RUNNING = new AtomicBoolean(false);
    private final RestTemplate restTemplate;
    private ExecutorService executor;
    private final List<String> serverList;
    private final DataRefreshFactory factory;
    private final AccessTokenManager accessTokenManager;

    public HttpSyncDataService(HttpConfig httpConfig, PluginDataSubscriber pluginDataSubscriber, RestTemplate restTemplate, List<MetaDataSubscriber> metaDataSubscribers, List<AuthDataSubscriber> authDataSubscribers, AccessTokenManager accessTokenManager) {
        this.accessTokenManager = accessTokenManager;
        this.factory = new DataRefreshFactory(pluginDataSubscriber, metaDataSubscribers, authDataSubscribers);
        this.serverList = Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)httpConfig.getUrl()));
        this.restTemplate = restTemplate;
        this.start();
    }

    private void start() {
        if (RUNNING.compareAndSet(false, true)) {
            this.fetchGroupConfig(ConfigGroupEnum.values());
            int threadSize = this.serverList.size();
            this.executor = new ThreadPoolExecutor(threadSize, threadSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), ShenyuThreadFactory.create((String)"http-long-polling", (boolean)true));
            this.serverList.forEach(server -> this.executor.execute(new HttpLongPollingTask((String)server)));
        } else {
            LOG.info("shenyu http long polling was started, executor=[{}]", (Object)this.executor);
        }
    }

    private void fetchGroupConfig(ConfigGroupEnum ... groups) throws ShenyuException {
        for (int index = 0; index < this.serverList.size(); ++index) {
            String server = this.serverList.get(index);
            try {
                this.doFetchGroupConfig(server, groups);
                break;
            }
            catch (ShenyuException e) {
                if (index >= this.serverList.size() - 1) {
                    throw e;
                }
                LOG.warn("fetch config fail, try another one: {}", (Object)this.serverList.get(index + 1));
                continue;
            }
        }
    }

    private void doFetchGroupConfig(String server, ConfigGroupEnum ... groups) {
        String json;
        StringBuilder params = new StringBuilder();
        for (ConfigGroupEnum groupKey : groups) {
            params.append("groupKeys").append("=").append(groupKey.name()).append("&");
        }
        String url = server + "/configs/fetch" + "?" + StringUtils.removeEnd((String)params.toString(), (String)"&");
        LOG.info("request configs: [{}]", (Object)url);
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.set("X-Access-Token", this.accessTokenManager.getAccessToken());
            HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
            json = (String)this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, String.class, new Object[0]).getBody();
        }
        catch (RestClientException e) {
            String message = String.format("fetch config fail from server[%s], %s", url, e.getMessage());
            LOG.warn(message);
            throw new ShenyuException(message, (Throwable)e);
        }
        boolean updated = this.updateCacheWithJson(json);
        if (updated) {
            LOG.debug("get latest configs: [{}]", (Object)json);
            return;
        }
        LOG.info("The config of the server[{}] has not been updated or is out of date. Wait for 30s to listen for changes again.", (Object)server);
        ThreadUtils.sleep((TimeUnit)TimeUnit.SECONDS, (int)30);
    }

    private boolean updateCacheWithJson(String json) {
        JsonObject jsonObject = (JsonObject)GsonUtils.getGson().fromJson(json, JsonObject.class);
        return this.factory.executor(jsonObject.getAsJsonObject("data"));
    }

    private void doLongPolling(String server) {
        JsonArray groupJson;
        LinkedMultiValueMap params = new LinkedMultiValueMap(8);
        for (ConfigGroupEnum group : ConfigGroupEnum.values()) {
            ConfigData<?> cacheConfig = this.factory.cacheConfigData(group);
            if (cacheConfig == null) continue;
            String value = String.join((CharSequence)",", cacheConfig.getMd5(), String.valueOf(cacheConfig.getLastModifyTime()));
            params.put((Object)group.name(), (Object)Lists.newArrayList((Object[])new String[]{value}));
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.set("X-Access-Token", this.accessTokenManager.getAccessToken());
        HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        String listenerUrl = server + "/configs/listener";
        try {
            String json = (String)this.restTemplate.postForEntity(listenerUrl, (Object)httpEntity, String.class, new Object[0]).getBody();
            LOG.info("listener result: [{}]", (Object)json);
            JsonObject responseFromServer = (JsonObject)GsonUtils.getGson().fromJson(json, JsonObject.class);
            groupJson = responseFromServer.getAsJsonArray("data");
        }
        catch (RestClientException e) {
            String message = String.format("listener configs fail, server:[%s], %s", server, e.getMessage());
            throw new ShenyuException(message, (Throwable)e);
        }
        if (Objects.nonNull(groupJson) && groupJson.size() > 0) {
            Object[] changedGroups = (ConfigGroupEnum[])GsonUtils.getGson().fromJson((JsonElement)groupJson, ConfigGroupEnum[].class);
            LOG.info("Group config changed: {}", (Object)Arrays.toString(changedGroups));
            this.doFetchGroupConfig(server, (ConfigGroupEnum[])changedGroups);
        }
    }

    public void close() {
        RUNNING.set(false);
        if (Objects.nonNull(this.executor)) {
            this.executor.shutdownNow();
            this.executor = null;
        }
    }

    class HttpLongPollingTask
    implements Runnable {
        private final String server;

        HttpLongPollingTask(String server) {
            this.server = server;
        }

        @Override
        public void run() {
            while (RUNNING.get()) {
                int retryTimes = 3;
                for (int time = 1; time <= retryTimes; ++time) {
                    try {
                        HttpSyncDataService.this.doLongPolling(this.server);
                        continue;
                    }
                    catch (Exception e) {
                        if (time < retryTimes) {
                            LOG.warn("Long polling failed, tried {} times, {} times left, will be suspended for a while! {}", new Object[]{time, retryTimes - time, e.getMessage()});
                            ThreadUtils.sleep((TimeUnit)TimeUnit.SECONDS, (int)5);
                            continue;
                        }
                        LOG.error("Long polling failed, try again after 5 minutes!", (Throwable)e);
                        ThreadUtils.sleep((TimeUnit)TimeUnit.MINUTES, (int)5);
                    }
                }
            }
            LOG.warn("Stop http long polling.");
        }
    }
}

