/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.sign.service;

import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.shenyu.common.dto.AppAuthData;
import org.apache.shenyu.common.dto.AuthParamData;
import org.apache.shenyu.common.dto.AuthPathData;
import org.apache.shenyu.common.utils.DateUtils;
import org.apache.shenyu.common.utils.PathMatchUtils;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.sign.api.ShenyuSignProviderWrap;
import org.apache.shenyu.plugin.sign.api.SignService;
import org.apache.shenyu.plugin.sign.cache.SignAuthDataCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.ObjectUtils;
import org.springframework.web.server.ServerWebExchange;

public class DefaultSignService
implements SignService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSignService.class);
    @Value(value="${shenyu.sign.delay:5}")
    private int delay;

    @Override
    public Pair<Boolean, String> signVerify(ServerWebExchange exchange, Map<String, Object> requestBody) {
        ShenyuContext shenyuContext = (ShenyuContext)exchange.getAttribute("context");
        assert (shenyuContext != null);
        return this.verify(shenyuContext, exchange, requestBody);
    }

    private Pair<Boolean, String> verify(ShenyuContext shenyuContext, ServerWebExchange exchange, Map<String, Object> requestBody) {
        LocalDateTime now;
        if (StringUtils.isBlank((CharSequence)shenyuContext.getAppKey()) || StringUtils.isBlank((CharSequence)shenyuContext.getSign()) || StringUtils.isBlank((CharSequence)shenyuContext.getTimestamp())) {
            LOG.error("sign parameters are incomplete,{}", (Object)shenyuContext);
            return Pair.of((Object)Boolean.FALSE, (Object)"sign parameters are incomplete!");
        }
        LocalDateTime start = DateUtils.formatLocalDateTimeFromTimestampBySystemTimezone((Long)Long.parseLong(shenyuContext.getTimestamp()));
        long between = DateUtils.acquireMinutesBetween((LocalDateTime)start, (LocalDateTime)(now = LocalDateTime.now()));
        if (between > (long)this.delay) {
            return Pair.of((Object)Boolean.FALSE, (Object)String.format(ShenyuResultEnum.SIGN_TIME_IS_TIMEOUT.getMsg(), this.delay));
        }
        return this.sign(shenyuContext, exchange, requestBody);
    }

    private Pair<Boolean, String> sign(ShenyuContext shenyuContext, ServerWebExchange exchange, Map<String, Object> requestBody) {
        String sigKey;
        boolean result;
        AppAuthData appAuthData = SignAuthDataCache.getInstance().obtainAuthData(shenyuContext.getAppKey());
        if (Objects.isNull(appAuthData) || Boolean.FALSE.equals(appAuthData.getEnabled())) {
            LOG.error("sign APP_kEY does not exist or has been disabled,{}", (Object)shenyuContext.getAppKey());
            return Pair.of((Object)Boolean.FALSE, (Object)"sign appKey does not exist.");
        }
        if (Boolean.TRUE.equals(appAuthData.getOpen())) {
            List pathDataList = appAuthData.getPathDataList();
            if (CollectionUtils.isEmpty((Collection)pathDataList)) {
                LOG.error("You have not configured the sign path:{}", (Object)shenyuContext.getAppKey());
                return Pair.of((Object)Boolean.FALSE, (Object)"you have not configured the sign path.");
            }
            boolean match = pathDataList.stream().filter(AuthPathData::getEnabled).anyMatch(e -> PathMatchUtils.match((String)e.getPath(), (String)shenyuContext.getPath()));
            if (!match) {
                LOG.error("You have not configured the sign path:{},{}", (Object)shenyuContext.getAppKey(), (Object)shenyuContext.getRealUrl());
                return Pair.of((Object)Boolean.FALSE, (Object)"you have not configured the sign path.");
            }
        }
        if (!(result = Objects.equals(sigKey = ShenyuSignProviderWrap.generateSign(appAuthData.getAppSecret(), this.buildParamsMap(shenyuContext, requestBody)), shenyuContext.getSign()))) {
            LOG.error("the SignUtils generated signature value is:{},the accepted value is:{}", (Object)sigKey, (Object)shenyuContext.getSign());
            return Pair.of((Object)Boolean.FALSE, (Object)"signature value is error!");
        }
        List paramDataList = appAuthData.getParamDataList();
        if (CollectionUtils.isEmpty((Collection)paramDataList)) {
            return Pair.of((Object)Boolean.TRUE, (Object)"");
        }
        paramDataList.stream().filter(p -> ("/" + p.getAppName()).equals(shenyuContext.getContextPath())).map(AuthParamData::getAppParam).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).findFirst().ifPresent(param -> exchange.getRequest().mutate().headers(httpHeaders -> httpHeaders.set("appParam", param)).build());
        return Pair.of((Object)Boolean.TRUE, (Object)"");
    }

    private Map<String, String> buildParamsMap(ShenyuContext shenyuContext, Map<String, Object> requestBody) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)3);
        map.put("timestamp", shenyuContext.getTimestamp());
        map.put("path", shenyuContext.getPath());
        map.put("version", "1.0.0");
        if (!ObjectUtils.isEmpty(requestBody)) {
            requestBody.forEach((key, value) -> map.putIfAbsent(key, Objects.toString(value, null)));
        }
        return map;
    }
}

