/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sync.data.zookeeper;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.curator.framework.recipes.cache.TreeCacheListener;
import org.apache.shenyu.common.dto.AppAuthData;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.PathMatchUtils;
import org.apache.shenyu.sync.data.api.AuthDataSubscriber;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.apache.shenyu.sync.data.api.SyncDataService;
import org.apache.shenyu.sync.data.zookeeper.ZookeeperClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperSyncDataService
implements SyncDataService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperSyncDataService.class);
    private final ZookeeperClient zkClient;
    private final PluginDataSubscriber pluginDataSubscriber;
    private final List<MetaDataSubscriber> metaDataSubscribers;
    private final List<AuthDataSubscriber> authDataSubscribers;

    public ZookeeperSyncDataService(ZookeeperClient zkClient, PluginDataSubscriber pluginDataSubscriber, List<MetaDataSubscriber> metaDataSubscribers, List<AuthDataSubscriber> authDataSubscribers) {
        this.zkClient = zkClient;
        this.pluginDataSubscriber = pluginDataSubscriber;
        this.metaDataSubscribers = metaDataSubscribers;
        this.authDataSubscribers = authDataSubscribers;
        this.watcherData();
        this.watchAppAuth();
        this.watchMetaData();
    }

    private void watcherData() {
        this.zkClient.addCache("/shenyu/plugin", new PluginCacheListener());
        this.zkClient.addCache("/shenyu/selector", new SelectorCacheListener());
        this.zkClient.addCache("/shenyu/rule", new RuleCacheListener());
    }

    private void watchAppAuth() {
        this.zkClient.addCache("/shenyu/auth", new AuthCacheListener());
    }

    private void watchMetaData() {
        this.zkClient.addCache("/shenyu/metaData", new MetadataCacheListener());
    }

    private void cachePluginData(PluginData pluginData) {
        Optional.ofNullable(pluginData).flatMap(data -> Optional.ofNullable(this.pluginDataSubscriber)).ifPresent(e -> e.onSubscribe(pluginData));
    }

    private void cacheSelectorData(SelectorData selectorData) {
        Optional.ofNullable(selectorData).ifPresent(data -> Optional.ofNullable(this.pluginDataSubscriber).ifPresent(e -> e.onSelectorSubscribe(data)));
    }

    private void unCacheSelectorData(String dataPath) {
        SelectorData selectorData = new SelectorData();
        String selectorId = dataPath.substring(dataPath.lastIndexOf("/") + 1);
        String str = dataPath.substring("/shenyu/selector".length());
        String pluginName = str.substring(1, str.length() - selectorId.length() - 1);
        selectorData.setPluginName(pluginName);
        selectorData.setId(selectorId);
        Optional.ofNullable(this.pluginDataSubscriber).ifPresent(e -> e.unSelectorSubscribe(selectorData));
    }

    private void cacheRuleData(RuleData ruleData) {
        Optional.ofNullable(ruleData).ifPresent(data -> Optional.ofNullable(this.pluginDataSubscriber).ifPresent(e -> e.onRuleSubscribe(data)));
    }

    private void unCacheRuleData(String dataPath) {
        String substring = dataPath.substring(dataPath.lastIndexOf("/") + 1);
        String str = dataPath.substring("/shenyu/rule".length());
        String pluginName = str.substring(1, str.length() - substring.length() - 1);
        ArrayList list = Lists.newArrayList((Iterable)Splitter.on((String)"-").split((CharSequence)substring));
        RuleData ruleData = new RuleData();
        ruleData.setPluginName(pluginName);
        ruleData.setSelectorId((String)list.get(0));
        ruleData.setId((String)list.get(1));
        Optional.ofNullable(this.pluginDataSubscriber).ifPresent(e -> e.unRuleSubscribe(ruleData));
    }

    private void cacheAuthData(AppAuthData appAuthData) {
        Optional.ofNullable(appAuthData).ifPresent(data -> this.authDataSubscribers.forEach(e -> e.onSubscribe(data)));
    }

    private void unCacheAuthData(String dataPath) {
        String key = dataPath.substring("/shenyu/auth".length() + 1);
        AppAuthData appAuthData = new AppAuthData();
        appAuthData.setAppKey(key);
        this.authDataSubscribers.forEach(e -> e.unSubscribe(appAuthData));
    }

    private void cacheMetaData(MetaData metaData) {
        Optional.ofNullable(metaData).ifPresent(data -> this.metaDataSubscribers.forEach(e -> e.onSubscribe(metaData)));
    }

    private void unCacheMetaData(MetaData metaData) {
        Optional.ofNullable(metaData).ifPresent(data -> this.metaDataSubscribers.forEach(e -> e.unSubscribe(metaData)));
    }

    public void close() {
        if (Objects.nonNull(this.zkClient)) {
            this.zkClient.close();
        }
    }

    class RuleCacheListener
    extends AbstractDataSyncListener {
        private static final String RULE_PATH = "/shenyu/rule/*/*";

        RuleCacheListener() {
        }

        @Override
        public void event(TreeCacheEvent.Type type, String path, ChildData data) {
            if (!PathMatchUtils.match((String)RULE_PATH, (String)path)) {
                return;
            }
            if (type.equals((Object)TreeCacheEvent.Type.NODE_REMOVED)) {
                ZookeeperSyncDataService.this.unCacheRuleData(path);
            }
            Optional.ofNullable(data).ifPresent(e -> ZookeeperSyncDataService.this.cacheRuleData((RuleData)GsonUtils.getInstance().fromJson(new String(data.getData(), StandardCharsets.UTF_8), RuleData.class)));
        }
    }

    class AuthCacheListener
    extends AbstractDataSyncListener {
        private static final String APP_AUTH_PATH = "/shenyu/auth/*";

        AuthCacheListener() {
        }

        @Override
        public void event(TreeCacheEvent.Type type, String path, ChildData data) {
            if (!PathMatchUtils.match((String)APP_AUTH_PATH, (String)path)) {
                return;
            }
            if (type.equals((Object)TreeCacheEvent.Type.NODE_REMOVED)) {
                ZookeeperSyncDataService.this.unCacheAuthData(path);
            }
            Optional.ofNullable(data).ifPresent(e -> ZookeeperSyncDataService.this.cacheAuthData((AppAuthData)GsonUtils.getInstance().fromJson(new String(data.getData(), StandardCharsets.UTF_8), AppAuthData.class)));
        }
    }

    class MetadataCacheListener
    extends AbstractDataSyncListener {
        private static final String META_DATA_PATH = "/shenyu/metaData/*";

        MetadataCacheListener() {
        }

        @Override
        public void event(TreeCacheEvent.Type type, String path, ChildData data) {
            if (!PathMatchUtils.match((String)META_DATA_PATH, (String)path)) {
                return;
            }
            if (type.equals((Object)TreeCacheEvent.Type.NODE_REMOVED)) {
                String realPath = path.substring("/shenyu/metaData".length() + 1);
                MetaData metaData = new MetaData();
                try {
                    metaData.setPath(URLDecoder.decode(realPath, StandardCharsets.UTF_8.name()));
                }
                catch (UnsupportedEncodingException e2) {
                    throw new ShenyuException((Throwable)e2);
                }
                ZookeeperSyncDataService.this.unCacheMetaData(metaData);
            }
            Optional.ofNullable(data).ifPresent(e -> ZookeeperSyncDataService.this.cacheMetaData((MetaData)GsonUtils.getInstance().fromJson(new String(data.getData(), StandardCharsets.UTF_8), MetaData.class)));
        }
    }

    class SelectorCacheListener
    extends AbstractDataSyncListener {
        private static final String SELECTOR_PATH = "/shenyu/selector/*/*";

        SelectorCacheListener() {
        }

        @Override
        public void event(TreeCacheEvent.Type type, String path, ChildData data) {
            if (!PathMatchUtils.match((String)SELECTOR_PATH, (String)path)) {
                return;
            }
            if (type.equals((Object)TreeCacheEvent.Type.NODE_REMOVED)) {
                ZookeeperSyncDataService.this.unCacheSelectorData(path);
            }
            Optional.ofNullable(data).ifPresent(e -> ZookeeperSyncDataService.this.cacheSelectorData((SelectorData)GsonUtils.getInstance().fromJson(new String(data.getData(), StandardCharsets.UTF_8), SelectorData.class)));
        }
    }

    class PluginCacheListener
    extends AbstractDataSyncListener {
        private static final String PLUGIN_PATH = "/shenyu/plugin/*";

        PluginCacheListener() {
        }

        @Override
        public void event(TreeCacheEvent.Type type, String path, ChildData data) {
            if (!PathMatchUtils.match((String)PLUGIN_PATH, (String)path)) {
                return;
            }
            String pluginName = path.substring(path.lastIndexOf("/") + 1);
            if (type.equals((Object)TreeCacheEvent.Type.NODE_REMOVED)) {
                PluginData pluginData = new PluginData();
                pluginData.setName(pluginName);
                Optional.ofNullable(ZookeeperSyncDataService.this.pluginDataSubscriber).ifPresent(e -> e.unSubscribe(pluginData));
            }
            Optional.ofNullable(data).ifPresent(e -> ZookeeperSyncDataService.this.cachePluginData((PluginData)GsonUtils.getInstance().fromJson(new String(data.getData(), StandardCharsets.UTF_8), PluginData.class)));
        }
    }

    abstract class AbstractDataSyncListener
    implements TreeCacheListener {
        AbstractDataSyncListener() {
        }

        public final void childEvent(CuratorFramework client, TreeCacheEvent event) {
            ChildData childData = event.getData();
            if (null == childData) {
                return;
            }
            String path = childData.getPath();
            if (Strings.isNullOrEmpty((String)path)) {
                return;
            }
            this.event(event.getType(), path, childData);
        }

        protected abstract void event(TreeCacheEvent.Type var1, String var2, ChildData var3);
    }
}

