/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.api.utils;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.shenyu.common.utils.ObjectTypeUtils;
import org.apache.shenyu.plugin.api.result.ShenyuResult;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public final class WebFluxResultUtils {
    private static final Logger LOG = LoggerFactory.getLogger(WebFluxResultUtils.class);

    private WebFluxResultUtils() {
    }

    public static Mono<Void> result(ServerWebExchange exchange, Object result) {
        if (Objects.isNull(result)) {
            return Mono.empty();
        }
        ShenyuResult<?> shenyuResult = ShenyuResultWrap.shenyuResult();
        Object resultData = shenyuResult.format(exchange, result);
        MediaType mediaType = MediaType.TEXT_PLAIN;
        if (!ObjectTypeUtils.isBasicType((Object)result)) {
            mediaType = shenyuResult.contentType(exchange, resultData);
        }
        exchange.getResponse().getHeaders().setContentType(mediaType);
        Object responseData = shenyuResult.result(exchange, resultData);
        assert (null != responseData);
        byte[] bytes = responseData instanceof byte[] ? (byte[])responseData : responseData.toString().getBytes(StandardCharsets.UTF_8);
        return exchange.getResponse().writeWith((Publisher)Mono.just((Object)exchange.getResponse().bufferFactory().wrap(bytes)).doOnNext(data -> exchange.getResponse().getHeaders().setContentLength((long)data.readableByteCount())));
    }

    public static Mono<Void> noSelectorResult(String pluginName, ServerWebExchange exchange) {
        LOG.error("can not match selector data: {}", (Object)pluginName);
        Object error = ShenyuResultWrap.error(exchange, ShenyuResultEnum.SELECTOR_NOT_FOUND.getCode(), pluginName + ":" + ShenyuResultEnum.SELECTOR_NOT_FOUND.getMsg(), null);
        return WebFluxResultUtils.result(exchange, error);
    }

    public static Mono<Void> noRuleResult(String pluginName, ServerWebExchange exchange) {
        LOG.error("can not match rule data: {}", (Object)pluginName);
        Object error = ShenyuResultWrap.error(exchange, ShenyuResultEnum.RULE_NOT_FOUND.getCode(), pluginName + ":" + ShenyuResultEnum.RULE_NOT_FOUND.getMsg(), null);
        return WebFluxResultUtils.result(exchange, error);
    }
}

