/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.api.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.ReflectUtils;
import org.springframework.util.LinkedMultiValueMap;

public final class BodyParamUtils {
    private static final Pattern QUERY_PARAM_PATTERN = Pattern.compile("([^&=]+)(=?)([^&]+)?");

    private BodyParamUtils() {
    }

    public static LinkedMultiValueMap<String, String> buildBodyParams(String param) {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        Matcher matcher = QUERY_PARAM_PATTERN.matcher(param);
        while (matcher.find()) {
            String name = matcher.group(1);
            String eq = matcher.group(2);
            String value = matcher.group(3);
            params.add((Object)name, (Object)(value != null ? value : (StringUtils.isNotBlank((CharSequence)eq) ? "" : null)));
        }
        return params;
    }

    public static Pair<String[], Object[]> buildSingleParameter(String body, String parameterTypes) {
        Map paramMap = GsonUtils.getInstance().toObjectMap(body);
        for (String key : paramMap.keySet()) {
            Object obj = paramMap.get(key);
            if (obj instanceof JsonObject) {
                paramMap.put(key, GsonUtils.getInstance().convertToMap(obj.toString()));
                continue;
            }
            if (obj instanceof JsonArray) {
                paramMap.put(key, GsonUtils.getInstance().fromList(obj.toString(), Object.class));
                continue;
            }
            paramMap.put(key, obj);
        }
        return new ImmutablePair((Object)new String[]{parameterTypes}, (Object)new Object[]{paramMap});
    }

    public static Pair<String[], Object[]> buildParameters(String body, String parameterTypes) {
        Map paramMap;
        ArrayList paramNameList = new ArrayList();
        ArrayList<Object> paramTypeList = new ArrayList<Object>();
        if (BodyParamUtils.isNameMapping(parameterTypes)) {
            Map paramNameMap = GsonUtils.getInstance().toObjectMap(parameterTypes, String.class);
            paramNameList.addAll(paramNameMap.keySet());
            paramTypeList.addAll(paramNameMap.values());
        } else {
            paramMap = GsonUtils.getInstance().toObjectMap(body);
            paramNameList.addAll(paramMap.keySet());
            paramTypeList.addAll(Arrays.asList(StringUtils.split((String)parameterTypes, (String)",")));
        }
        if (paramTypeList.size() == 1 && !BodyParamUtils.isBaseType((String)paramTypeList.get(0))) {
            return BodyParamUtils.buildSingleParameter(body, parameterTypes);
        }
        paramMap = GsonUtils.getInstance().toObjectMap(body);
        Object[] objects = paramNameList.stream().map(key -> {
            Object obj = paramMap.get(key);
            if (obj instanceof JsonObject) {
                return GsonUtils.getInstance().convertToMap(obj.toString());
            }
            if (obj instanceof JsonArray) {
                return GsonUtils.getInstance().fromList(obj.toString(), Object.class);
            }
            return obj;
        }).toArray();
        String[] paramTypes = paramTypeList.toArray(new String[0]);
        return new ImmutablePair((Object)paramTypes, (Object)objects);
    }

    private static boolean isNameMapping(String parameterTypes) {
        return parameterTypes.startsWith("{") && parameterTypes.endsWith("}");
    }

    private static boolean isBaseType(String paramType) {
        try {
            return ReflectUtils.isPrimitives((Class)ClassUtils.getClass((String)paramType));
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

