/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client;

import com.alibaba.fastjson.JSON;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.configcenter.ConfigChangedEvent;
import org.apache.dubbo.common.config.configcenter.file.FileSystemDynamicConfiguration;
import org.apache.dubbo.common.lang.ShutdownHookCallbacks;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.event.EventListener;
import org.apache.dubbo.registry.client.AbstractServiceDiscovery;
import org.apache.dubbo.registry.client.DefaultServiceInstance;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.event.ServiceInstancesChangedEvent;

public class FileSystemServiceDiscovery
extends AbstractServiceDiscovery
implements EventListener<ServiceInstancesChangedEvent> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<File, FileLock> fileLocksCache = new ConcurrentHashMap<File, FileLock>();
    private FileSystemDynamicConfiguration dynamicConfiguration;

    @Override
    public void onEvent(ServiceInstancesChangedEvent event) {
    }

    @Override
    public void initialize(URL registryURL) throws Exception {
        this.dynamicConfiguration = FileSystemServiceDiscovery.createDynamicConfiguration(registryURL);
        this.registerDubboShutdownHook();
        this.registerListener();
    }

    private void registerDubboShutdownHook() {
        ShutdownHookCallbacks.INSTANCE.addCallback(this::destroy);
    }

    private void registerListener() {
        this.getServices().forEach(serviceName -> this.dynamicConfiguration.getConfigKeys("dubbo").forEach(serviceInstanceId -> this.dynamicConfiguration.addListener((String)serviceInstanceId, (String)serviceName, this::onConfigChanged)));
    }

    public void onConfigChanged(ConfigChangedEvent event) {
    }

    @Override
    public void destroy() throws Exception {
        this.dynamicConfiguration.close();
        this.releaseAndRemoveRegistrationFiles();
    }

    private void releaseAndRemoveRegistrationFiles() {
        this.fileLocksCache.keySet().forEach(file -> {
            this.releaseFileLock((File)file);
            this.removeFile((File)file);
        });
    }

    private void removeFile(File file) {
        FileUtils.deleteQuietly((File)file);
    }

    private String getServiceInstanceId(ServiceInstance serviceInstance) {
        String id = serviceInstance.getId();
        if (StringUtils.isBlank(id)) {
            return serviceInstance.getHost() + "." + serviceInstance.getPort();
        }
        return id;
    }

    private String getServiceName(ServiceInstance serviceInstance) {
        return serviceInstance.getServiceName();
    }

    @Override
    public List<ServiceInstance> getInstances(String serviceName) {
        return this.dynamicConfiguration.getConfigKeys("dubbo").stream().map(serviceInstanceId -> this.dynamicConfiguration.getConfig((String)serviceInstanceId, serviceName)).map(content -> (DefaultServiceInstance)JSON.parseObject((String)content, DefaultServiceInstance.class)).collect(Collectors.toList());
    }

    @Override
    public URL getUrl() {
        return null;
    }

    @Override
    public void doRegister(ServiceInstance serviceInstance) {
        String content;
        String serviceName;
        String serviceInstanceId = this.getServiceInstanceId(serviceInstance);
        if (this.dynamicConfiguration.publishConfig(serviceInstanceId, serviceName = this.getServiceName(serviceInstance), content = JSON.toJSONString((Object)serviceInstance))) {
            this.lockFile(serviceInstanceId, serviceName);
        }
    }

    private void lockFile(String serviceInstanceId, String serviceName) {
        File serviceInstanceFile = this.serviceInstanceFile(serviceInstanceId, serviceName);
        Path serviceInstanceFilePath = serviceInstanceFile.toPath();
        this.fileLocksCache.computeIfAbsent(serviceInstanceFile, file -> {
            FileLock fileLock;
            block3: {
                fileLock = null;
                try {
                    FileChannel fileChannel = FileChannel.open(serviceInstanceFilePath, StandardOpenOption.READ, StandardOpenOption.WRITE, LinkOption.NOFOLLOW_LINKS);
                    fileLock = fileChannel.tryLock();
                }
                catch (IOException e) {
                    if (!this.logger.isErrorEnabled()) break block3;
                    this.logger.error(e.getMessage(), e);
                }
            }
            if (fileLock != null && this.logger.isInfoEnabled()) {
                this.logger.info(String.format("%s has been locked", serviceInstanceFilePath.toAbsolutePath()));
            }
            return fileLock;
        });
    }

    @Override
    public void doUpdate(ServiceInstance serviceInstance) {
        this.register(serviceInstance);
    }

    @Override
    public void unregister(ServiceInstance serviceInstance) throws RuntimeException {
        String key = this.getServiceInstanceId(serviceInstance);
        String group = this.getServiceName(serviceInstance);
        this.releaseFileLock(key, group);
        this.dynamicConfiguration.removeConfig(key, group);
    }

    private void releaseFileLock(String serviceInstanceId, String serviceName) {
        File serviceInstanceFile = this.serviceInstanceFile(serviceInstanceId, serviceName);
        this.releaseFileLock(serviceInstanceFile);
    }

    private void releaseFileLock(File serviceInstanceFile) {
        this.fileLocksCache.computeIfPresent(serviceInstanceFile, (f, fileLock) -> {
            this.releaseFileLock((FileLock)fileLock);
            if (this.logger.isInfoEnabled()) {
                this.logger.info(String.format("The file[%s] has been released", serviceInstanceFile.getAbsolutePath()));
            }
            return null;
        });
    }

    private void releaseFileLock(FileLock fileLock) {
        block8: {
            try (FileChannel fileChannel = fileLock.channel();){
                fileLock.release();
            }
            catch (IOException e) {
                if (!this.logger.isErrorEnabled()) break block8;
                this.logger.error(e.getMessage(), e);
            }
        }
    }

    private File serviceInstanceFile(String serviceInstanceId, String serviceName) {
        return this.dynamicConfiguration.configFile(serviceInstanceId, serviceName);
    }

    @Override
    public Set<String> getServices() {
        return this.dynamicConfiguration.getConfigGroups();
    }

    private static FileSystemDynamicConfiguration createDynamicConfiguration(URL connectionURL) {
        String path = System.getProperty("user.home") + File.separator + ".dubbo" + File.separator + "registry";
        return new FileSystemDynamicConfiguration(connectionURL.addParameter("dubbo.config-center.dir", path));
    }
}

