/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import org.apache.dubbo.common.serialize.Cleanable;
import org.apache.dubbo.common.serialize.ObjectInput;
import org.apache.dubbo.common.serialize.kryo.utils.KryoUtils;

public class KryoObjectInput
implements ObjectInput,
Cleanable {
    private Kryo kryo;
    private Input input;

    public KryoObjectInput(InputStream inputStream) {
        this.input = new Input(inputStream);
        this.kryo = KryoUtils.get();
    }

    @Override
    public boolean readBool() throws IOException {
        try {
            return this.input.readBoolean();
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public byte readByte() throws IOException {
        try {
            return this.input.readByte();
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public short readShort() throws IOException {
        try {
            return this.input.readShort();
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int readInt() throws IOException {
        try {
            return this.input.readInt();
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public long readLong() throws IOException {
        try {
            return this.input.readLong();
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public float readFloat() throws IOException {
        try {
            return this.input.readFloat();
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public double readDouble() throws IOException {
        try {
            return this.input.readDouble();
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public byte[] readBytes() throws IOException {
        try {
            int len = this.input.readInt();
            if (len < 0) {
                return null;
            }
            if (len == 0) {
                return new byte[0];
            }
            return this.input.readBytes(len);
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public String readUTF() throws IOException {
        try {
            return this.input.readString();
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Object readObject() throws IOException, ClassNotFoundException {
        try {
            return this.kryo.readClassAndObject(this.input);
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public <T> T readObject(Class<T> clazz) throws IOException, ClassNotFoundException {
        return (T)this.readObject();
    }

    @Override
    public <T> T readObject(Class<T> clazz, Type type) throws IOException, ClassNotFoundException {
        return this.readObject(clazz);
    }

    @Override
    public void cleanup() {
        KryoUtils.release(this.kryo);
        this.kryo = null;
    }
}

