/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.ratelimiter.algorithm;

import java.util.Arrays;
import java.util.List;
import org.apache.shenyu.plugin.ratelimiter.algorithm.RateLimiterAlgorithm;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.support.ResourceScriptSource;

public abstract class AbstractRateLimiterAlgorithm
implements RateLimiterAlgorithm<List<Long>> {
    private final String scriptName;
    private final RedisScript<List<Long>> script;

    protected AbstractRateLimiterAlgorithm(String scriptName) {
        DefaultRedisScript redisScript = new DefaultRedisScript();
        String scriptPath = "/META-INF/scripts/" + scriptName;
        redisScript.setScriptSource((ScriptSource)new ResourceScriptSource((Resource)new ClassPathResource(scriptPath)));
        redisScript.setResultType(List.class);
        this.script = redisScript;
        this.scriptName = scriptName;
    }

    protected abstract String getKeyName();

    @Override
    public String getScriptName() {
        return this.scriptName;
    }

    @Override
    public RedisScript<List<Long>> getScript() {
        return this.script;
    }

    @Override
    public List<String> getKeys(String id) {
        String prefix = this.getKeyName() + ".{" + id;
        String tokenKey = prefix + "}.tokens";
        String timestampKey = prefix + "}.timestamp";
        return Arrays.asList(tokenKey, timestampKey);
    }
}

