/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.grpc.client;

import io.grpc.ClientInterceptor;
import io.grpc.LoadBalancerProvider;
import io.grpc.LoadBalancerRegistry;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.NameResolverProvider;
import io.grpc.NameResolverRegistry;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.apache.shenyu.common.concurrent.ShenyuThreadPoolExecutor;
import org.apache.shenyu.common.dto.convert.plugin.GrpcRegisterConfig;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.plugin.api.utils.SpringBeanUtils;
import org.apache.shenyu.plugin.grpc.client.ShenyuGrpcClient;
import org.apache.shenyu.plugin.grpc.intercept.ContextClientInterceptor;
import org.apache.shenyu.plugin.grpc.loadbalance.LoadBalancerStrategy;
import org.apache.shenyu.plugin.grpc.loadbalance.RandomLoadBalancerProvider;
import org.apache.shenyu.plugin.grpc.loadbalance.RoundRobinLoadBalancerProvider;
import org.apache.shenyu.plugin.grpc.resolver.ShenyuNameResolverProvider;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public final class GrpcClientBuilder {
    private GrpcClientBuilder() {
    }

    public static ShenyuGrpcClient buildClient(String contextPath) {
        ManagedChannelBuilder builder = ManagedChannelBuilder.forTarget((String)contextPath).intercept(new ClientInterceptor[]{new ContextClientInterceptor()}).defaultLoadBalancingPolicy(LoadBalancerStrategy.RANDOM.getStrategy()).usePlaintext().maxInboundMessageSize(0x6400000).executor(GrpcClientBuilder.buildExecutor()).disableRetry();
        ManagedChannel channel = builder.build();
        channel.getState(true);
        return new ShenyuGrpcClient(channel);
    }

    public static Executor buildExecutor() {
        String threadpool;
        GrpcRegisterConfig config = (GrpcRegisterConfig)Singleton.INST.get(GrpcRegisterConfig.class);
        if (null == config) {
            return null;
        }
        switch (threadpool = Optional.ofNullable(config.getThreadpool()).orElse("cached")) {
            case "shared": {
                try {
                    return (Executor)SpringBeanUtils.getInstance().getBean(ShenyuThreadPoolExecutor.class);
                }
                catch (NoSuchBeanDefinitionException t) {
                    throw new ShenyuException("shared thread pool is not enable, config ${shenyu.sharedPool.enable} in your xml/yml !", (Throwable)t);
                }
            }
            case "fixed": 
            case "eager": 
            case "limited": {
                throw new UnsupportedOperationException();
            }
        }
        return null;
    }

    static {
        LoadBalancerRegistry.getDefaultRegistry().register((LoadBalancerProvider)new RandomLoadBalancerProvider());
        LoadBalancerRegistry.getDefaultRegistry().register((LoadBalancerProvider)new RoundRobinLoadBalancerProvider());
        NameResolverRegistry.getDefaultRegistry().register((NameResolverProvider)new ShenyuNameResolverProvider());
    }
}

