/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.grpc.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.selector.GrpcUpstream;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.plugin.grpc.cache.GrpcClientCache;
import org.apache.shenyu.plugin.grpc.resolver.ShenyuServiceInstance;
import org.apache.shenyu.plugin.grpc.resolver.ShenyuServiceInstanceLists;
import org.springframework.lang.NonNull;

public final class ApplicationConfigCache {
    private final LoadingCache<String, ShenyuServiceInstanceLists> cache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<String, ShenyuServiceInstanceLists>(){

        @NonNull
        public ShenyuServiceInstanceLists load(@NonNull String key) {
            return new ShenyuServiceInstanceLists(key);
        }
    });
    private final Map<String, Consumer<Object>> listener = new ConcurrentHashMap<String, Consumer<Object>>();

    private ApplicationConfigCache() {
    }

    public ShenyuServiceInstanceLists get(String contextPath) {
        try {
            return (ShenyuServiceInstanceLists)this.cache.get((Object)contextPath);
        }
        catch (ExecutionException e) {
            throw new ShenyuException(e.getCause());
        }
    }

    public void initPrx(SelectorData selectorData) {
        try {
            List upstreamList = GsonUtils.getInstance().fromList(selectorData.getHandle(), GrpcUpstream.class);
            if (CollectionUtils.isEmpty((Collection)upstreamList)) {
                this.invalidate(selectorData.getName());
                return;
            }
            ShenyuServiceInstanceLists shenyuServiceInstances = (ShenyuServiceInstanceLists)this.cache.get((Object)selectorData.getName());
            List<ShenyuServiceInstance> instances = shenyuServiceInstances.getShenyuServiceInstances();
            instances.clear();
            instances.addAll(upstreamList.stream().map(this::build).collect(Collectors.toList()));
            Consumer<Object> consumer = this.listener.get(selectorData.getName());
            if (Objects.nonNull(consumer)) {
                consumer.accept(System.currentTimeMillis());
            }
        }
        catch (ExecutionException e) {
            throw new ShenyuException(e.getCause());
        }
    }

    public void invalidate(String contextPath) {
        this.cache.invalidate((Object)contextPath);
        this.listener.remove(contextPath);
        GrpcClientCache.removeClient(contextPath);
    }

    public void watch(String key, Consumer<Object> consumer) {
        this.listener.put(key, consumer);
    }

    public static ApplicationConfigCache getInstance() {
        return ApplicationConfigCacheInstance.INSTANCE;
    }

    private ShenyuServiceInstance build(GrpcUpstream grpcUpstream) {
        String[] ipAndPort = grpcUpstream.getUpstreamUrl().split(":");
        ShenyuServiceInstance instance = new ShenyuServiceInstance(ipAndPort[0], Integer.parseInt(ipAndPort[1]));
        instance.setWeight(grpcUpstream.getWeight());
        instance.setStatus(grpcUpstream.isStatus());
        return instance;
    }

    static final class ApplicationConfigCacheInstance {
        static final ApplicationConfigCache INSTANCE = new ApplicationConfigCache();

        private ApplicationConfigCacheInstance() {
        }
    }
}

