/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.logging.common.collector;

import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.shenyu.common.concurrent.MemorySafeTaskQueue;
import org.apache.shenyu.common.concurrent.ShenyuThreadFactory;
import org.apache.shenyu.common.concurrent.ShenyuThreadPoolExecutor;
import org.apache.shenyu.common.concurrent.TaskQueue;
import org.apache.shenyu.common.config.ShenyuConfig;
import org.apache.shenyu.common.utils.ThreadUtils;
import org.apache.shenyu.plugin.logging.common.client.LogConsumeClient;
import org.apache.shenyu.plugin.logging.common.collector.LogCollector;
import org.apache.shenyu.plugin.logging.common.entity.ShenyuRequestLog;
import org.apache.shenyu.plugin.logging.common.utils.LogCollectConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLogCollector
implements LogCollector {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLogCollector.class);
    private int bufferSize;
    private BlockingQueue<ShenyuRequestLog> bufferQueue;
    private long lastPushTime;
    private final AtomicBoolean started = new AtomicBoolean(true);
    private final ShenyuConfig config = new ShenyuConfig();

    @Override
    public void start() {
        this.bufferSize = LogCollectConfigUtils.getGenericGlobalConfig().getBufferQueueSize();
        this.bufferQueue = new LinkedBlockingDeque<ShenyuRequestLog>(this.bufferSize);
        ShenyuConfig.SharedPool sharedPool = this.config.getSharedPool();
        ShenyuThreadPoolExecutor threadExecutor = new ShenyuThreadPoolExecutor(sharedPool.getCorePoolSize().intValue(), sharedPool.getMaximumPoolSize().intValue(), sharedPool.getKeepAliveTime().longValue(), TimeUnit.MILLISECONDS, (TaskQueue)new MemorySafeTaskQueue(0x10000000), ShenyuThreadFactory.create((String)this.config.getSharedPool().getPrefix(), (boolean)true), (RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
        this.started.set(true);
        threadExecutor.execute(this::consume);
    }

    @Override
    public void collect(ShenyuRequestLog log) {
        if (Objects.isNull(log) || Objects.isNull(this.getLogConsumeClient())) {
            return;
        }
        if (this.bufferQueue.size() < this.bufferSize) {
            this.bufferQueue.add(log);
        }
    }

    private void consume() {
        while (this.started.get()) {
            int diffTimeMSForPush = 100;
            try {
                ArrayList<ShenyuRequestLog> logs = new ArrayList<ShenyuRequestLog>();
                int size = this.bufferQueue.size();
                long time = System.currentTimeMillis();
                long timeDiffMs = time - this.lastPushTime;
                int batchSize = 100;
                if (size >= batchSize || timeDiffMs > (long)diffTimeMSForPush) {
                    this.bufferQueue.drainTo(logs, batchSize);
                    LogConsumeClient logCollectClient = this.getLogConsumeClient();
                    if (Objects.nonNull(logCollectClient)) {
                        logCollectClient.consume(logs);
                    }
                    this.lastPushTime = time;
                    continue;
                }
                ThreadUtils.sleep((TimeUnit)TimeUnit.MILLISECONDS, (int)diffTimeMSForPush);
            }
            catch (Exception e) {
                LOG.error("DefaultLogCollector collect log error", (Throwable)e);
                ThreadUtils.sleep((TimeUnit)TimeUnit.MILLISECONDS, (int)diffTimeMSForPush);
            }
        }
    }

    protected abstract LogConsumeClient getLogConsumeClient();

    @Override
    public void close() throws Exception {
        this.started.set(false);
        LogConsumeClient logCollectClient = this.getLogConsumeClient();
        if (logCollectClient != null) {
            logCollectClient.close();
        }
    }
}

