/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.logging.common;

import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.base.utils.HostAddressUtils;
import org.apache.shenyu.plugin.logging.common.entity.ShenyuRequestLog;
import org.apache.shenyu.plugin.logging.common.utils.LogCollectConfigUtils;
import org.apache.shenyu.plugin.logging.common.utils.LogCollectUtils;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public abstract class AbstractLoggingPlugin
extends AbstractShenyuPlugin {
    protected abstract Mono<Void> doLogExecute(ServerWebExchange var1, ShenyuPluginChain var2, SelectorData var3, RuleData var4, ServerHttpRequest var5, ShenyuRequestLog var6);

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        ServerHttpRequest request = exchange.getRequest();
        if (!LogCollectConfigUtils.isSampled(exchange.getRequest())) {
            return chain.execute(exchange);
        }
        ShenyuRequestLog requestInfo = new ShenyuRequestLog();
        requestInfo.setRequestUri(request.getURI().toString());
        requestInfo.setMethod(request.getMethodValue());
        requestInfo.setRequestHeader(LogCollectUtils.getHeaders(request.getHeaders()));
        requestInfo.setQueryParams(request.getURI().getQuery());
        requestInfo.setClientIp(HostAddressUtils.acquireIp((ServerWebExchange)exchange));
        requestInfo.setUserAgent(request.getHeaders().getFirst("User-Agent"));
        requestInfo.setHost(request.getHeaders().getFirst("Host"));
        requestInfo.setPath(request.getURI().getPath());
        return this.doLogExecute(exchange, chain, selector, rule, request, requestInfo);
    }
}

