/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.springcloud.handler;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.impl.SpringCloudRuleHandle;
import org.apache.shenyu.common.dto.convert.selector.DivideUpstream;
import org.apache.shenyu.common.dto.convert.selector.SpringCloudSelectorHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.loadbalancer.cache.UpstreamCacheManager;
import org.apache.shenyu.loadbalancer.entity.Upstream;
import org.apache.shenyu.plugin.base.cache.CommonHandleCache;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.base.utils.BeanHolder;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;

public class SpringCloudPluginDataHandler
implements PluginDataHandler {
    public static final Supplier<CommonHandleCache<String, SpringCloudSelectorHandle>> SELECTOR_CACHED = new BeanHolder(CommonHandleCache::new);
    public static final Supplier<CommonHandleCache<String, SpringCloudRuleHandle>> RULE_CACHED = new BeanHolder(CommonHandleCache::new);

    public void handlerSelector(SelectorData selectorData) {
        SpringCloudSelectorHandle springCloudSelectorHandle = (SpringCloudSelectorHandle)GsonUtils.getInstance().fromJson(selectorData.getHandle(), SpringCloudSelectorHandle.class);
        SELECTOR_CACHED.get().cachedHandle((Object)selectorData.getId(), (Object)springCloudSelectorHandle);
        if (CollectionUtils.isEmpty((Collection)springCloudSelectorHandle.getDivideUpstreams())) {
            UpstreamCacheManager.getInstance().removeByKey(selectorData.getId());
            return;
        }
        UpstreamCacheManager.getInstance().submit(selectorData.getId(), this.convertUpstreamList(springCloudSelectorHandle.getDivideUpstreams()));
    }

    public void removeSelector(SelectorData selectorData) {
        SELECTOR_CACHED.get().removeHandle((Object)selectorData.getId());
        UpstreamCacheManager.getInstance().removeByKey(selectorData.getId());
    }

    public void handlerRule(RuleData ruleData) {
        Optional.ofNullable(ruleData.getHandle()).ifPresent(s -> {
            SpringCloudRuleHandle springCloudRuleHandle = (SpringCloudRuleHandle)GsonUtils.getInstance().fromJson(s, SpringCloudRuleHandle.class);
            RULE_CACHED.get().cachedHandle((Object)CacheKeyUtils.INST.getKey(ruleData), (Object)springCloudRuleHandle);
        });
    }

    public void removeRule(RuleData ruleData) {
        Optional.ofNullable(ruleData.getHandle()).ifPresent(s -> RULE_CACHED.get().removeHandle((Object)CacheKeyUtils.INST.getKey(ruleData)));
    }

    public String pluginNamed() {
        return PluginEnum.SPRING_CLOUD.getName();
    }

    private List<Upstream> convertUpstreamList(List<DivideUpstream> upstreamList) {
        return upstreamList.stream().map(u -> Upstream.builder().protocol(u.getProtocol()).url(u.getUpstreamUrl()).weight(u.getWeight()).status(u.isStatus()).timestamp(u.getTimestamp()).warmup(u.getWarmup()).build()).collect(Collectors.toList());
    }
}

