/*
 * Decompiled with CFR 0.152.
 */
package brave;

import brave.Clock;
import brave.ErrorParser;
import brave.Tracer;
import brave.internal.Nullable;
import brave.internal.Platform;
import brave.internal.recorder.Recorder;
import brave.propagation.B3Propagation;
import brave.propagation.CurrentTraceContext;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.sampler.Sampler;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicBoolean;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.reporter.Reporter;

public abstract class Tracing
implements Closeable {
    static volatile Tracing current = null;
    final AtomicBoolean noop = new AtomicBoolean(false);

    public static Builder newBuilder() {
        return new Builder();
    }

    public abstract Tracer tracer();

    public Propagation<String> propagation() {
        return this.propagationFactory().create(Propagation.KeyFactory.STRING);
    }

    public abstract Propagation.Factory propagationFactory();

    public abstract Sampler sampler();

    public abstract CurrentTraceContext currentTraceContext();

    public final Clock clock(TraceContext context) {
        return this.tracer().recorder.clock(context);
    }

    public abstract ErrorParser errorParser();

    @Nullable
    public static Tracer currentTracer() {
        Tracing tracing = current;
        return tracing != null ? tracing.tracer() : null;
    }

    public boolean isNoop() {
        return this.noop.get();
    }

    public void setNoop(boolean noop) {
        this.noop.set(noop);
    }

    @Nullable
    public static Tracing current() {
        return current;
    }

    @Override
    public abstract void close();

    Tracing() {
    }

    static final class Default
    extends Tracing {
        final Tracer tracer;
        final Propagation.Factory propagationFactory;
        final Propagation<String> stringPropagation;
        final CurrentTraceContext currentTraceContext;
        final Sampler sampler;
        final Clock clock;
        final ErrorParser errorParser;

        Default(Builder builder) {
            this.clock = builder.clock;
            this.errorParser = builder.errorParser;
            this.propagationFactory = builder.propagationFactory;
            this.stringPropagation = builder.propagationFactory.create(Propagation.KeyFactory.STRING);
            this.currentTraceContext = builder.currentTraceContext;
            this.sampler = builder.sampler;
            this.tracer = new Tracer(builder.clock, builder.propagationFactory, builder.reporter, new Recorder(builder.endpoint, this.clock, builder.reporter, this.noop), builder.sampler, builder.errorParser, builder.currentTraceContext, builder.traceId128Bit || this.propagationFactory.requires128BitTraceId(), builder.supportsJoin && this.propagationFactory.supportsJoin(), this.noop);
            this.maybeSetCurrent();
        }

        @Override
        public Tracer tracer() {
            return this.tracer;
        }

        @Override
        public Propagation<String> propagation() {
            return this.stringPropagation;
        }

        @Override
        public Propagation.Factory propagationFactory() {
            return this.propagationFactory;
        }

        @Override
        public Sampler sampler() {
            return this.sampler;
        }

        @Override
        public CurrentTraceContext currentTraceContext() {
            return this.currentTraceContext;
        }

        @Override
        public ErrorParser errorParser() {
            return this.errorParser;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void maybeSetCurrent() {
            if (current != null) {
                return;
            }
            Class<Tracing> clazz = Tracing.class;
            synchronized (Tracing.class) {
                if (current == null) {
                    current = this;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (current != this) {
                return;
            }
            Class<Tracing> clazz = Tracing.class;
            synchronized (Tracing.class) {
                if (current == this) {
                    current = null;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }

    public static final class Builder {
        String localServiceName;
        Endpoint endpoint;
        Reporter<Span> reporter;
        Clock clock;
        Sampler sampler = Sampler.ALWAYS_SAMPLE;
        CurrentTraceContext currentTraceContext = CurrentTraceContext.Default.inheritable();
        boolean traceId128Bit = false;
        boolean supportsJoin = true;
        Propagation.Factory propagationFactory = B3Propagation.FACTORY;
        ErrorParser errorParser = new ErrorParser();

        public Builder localServiceName(String localServiceName) {
            if (localServiceName == null) {
                throw new NullPointerException("localServiceName == null");
            }
            this.localServiceName = localServiceName;
            return this;
        }

        public Builder endpoint(Endpoint endpoint) {
            if (endpoint == null) {
                throw new NullPointerException("endpoint == null");
            }
            this.endpoint = endpoint;
            return this;
        }

        public Builder spanReporter(Reporter<Span> reporter) {
            if (reporter == null) {
                throw new NullPointerException("spanReporter == null");
            }
            this.reporter = reporter;
            return this;
        }

        public Builder clock(Clock clock) {
            if (clock == null) {
                throw new NullPointerException("clock == null");
            }
            this.clock = clock;
            return this;
        }

        public Builder sampler(Sampler sampler) {
            if (sampler == null) {
                throw new NullPointerException("sampler == null");
            }
            this.sampler = sampler;
            return this;
        }

        public Builder currentTraceContext(CurrentTraceContext currentTraceContext) {
            if (currentTraceContext == null) {
                throw new NullPointerException("currentTraceContext == null");
            }
            this.currentTraceContext = currentTraceContext;
            return this;
        }

        public Builder propagationFactory(Propagation.Factory propagationFactory) {
            if (propagationFactory == null) {
                throw new NullPointerException("propagationFactory == null");
            }
            this.propagationFactory = propagationFactory;
            return this;
        }

        public Builder traceId128Bit(boolean traceId128Bit) {
            this.traceId128Bit = traceId128Bit;
            return this;
        }

        public Builder supportsJoin(boolean supportsJoin) {
            this.supportsJoin = supportsJoin;
            return this;
        }

        public Builder errorParser(ErrorParser errorParser) {
            this.errorParser = errorParser;
            return this;
        }

        public Tracing build() {
            if (this.clock == null) {
                this.clock = Platform.get().clock();
            }
            if (this.endpoint == null) {
                this.endpoint = Platform.get().endpoint();
                if (this.localServiceName != null) {
                    this.endpoint = this.endpoint.toBuilder().serviceName(this.localServiceName).build();
                }
            }
            if (this.reporter == null) {
                this.reporter = Platform.get().reporter();
            }
            return new Default(this);
        }

        Builder() {
        }
    }
}

