/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.web.configuration;

import java.lang.instrument.Instrumentation;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.bytebuddy.agent.ByteBuddyAgent;
import org.apache.shenyu.common.concurrent.MemoryLimitedTaskQueue;
import org.apache.shenyu.common.concurrent.MemorySafeTaskQueue;
import org.apache.shenyu.common.concurrent.ShenyuThreadFactory;
import org.apache.shenyu.common.concurrent.ShenyuThreadPoolExecutor;
import org.apache.shenyu.common.concurrent.TaskQueue;
import org.apache.shenyu.common.config.ShenyuConfig;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.plugin.api.utils.SpringBeanUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextClosedEvent;

@Configuration
public class ShenyuThreadPoolConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={TaskQueue.class})
    @ConditionalOnProperty(value={"shenyu.shared-pool.max-work-queue-memory"})
    public TaskQueue<Runnable> memoryLimitedTaskQueue(ShenyuConfig shenyuConfig) {
        Instrumentation instrumentation = ByteBuddyAgent.install();
        ShenyuConfig.SharedPool sharedPool = shenyuConfig.getSharedPool();
        Long maxWorkQueueMemory = sharedPool.getMaxWorkQueueMemory();
        if (maxWorkQueueMemory <= 0L) {
            throw new ShenyuException("${shenyu.sharedPool.maxWorkQueueMemory} must bigger than 0 !");
        }
        return new MemoryLimitedTaskQueue(maxWorkQueueMemory.longValue(), instrumentation);
    }

    @Bean
    @ConditionalOnMissingBean(value={TaskQueue.class})
    @ConditionalOnProperty(value={"shenyu.shared-pool.max-free-memory"})
    public TaskQueue<Runnable> memorySafeTaskQueue(ShenyuConfig shenyuConfig) {
        ShenyuConfig.SharedPool sharedPool = shenyuConfig.getSharedPool();
        Integer maxFreeMemory = sharedPool.getMaxFreeMemory();
        if (maxFreeMemory <= 0) {
            throw new ShenyuException("${shenyu.sharedPool.maxFreeMemory} must bigger than 0 !");
        }
        return new MemorySafeTaskQueue(maxFreeMemory.intValue());
    }

    @Bean
    @ConditionalOnProperty(name={"shenyu.shared-pool.enable"}, havingValue="true", matchIfMissing=true)
    public ShenyuThreadPoolExecutor shenyuThreadPoolExecutor(ShenyuConfig shenyuConfig, ObjectProvider<TaskQueue<Runnable>> provider) {
        ShenyuConfig.SharedPool sharedPool = shenyuConfig.getSharedPool();
        Integer corePoolSize = sharedPool.getCorePoolSize();
        Integer maximumPoolSize = sharedPool.getMaximumPoolSize();
        Long keepAliveTime = sharedPool.getKeepAliveTime();
        return new ShenyuThreadPoolExecutor(corePoolSize.intValue(), maximumPoolSize.intValue(), keepAliveTime.longValue(), TimeUnit.MILLISECONDS, (TaskQueue)provider.getIfAvailable(() -> new MemorySafeTaskQueue(0x10000000)), ShenyuThreadFactory.create((String)sharedPool.getPrefix(), (boolean)true), (RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
    }

    @Bean
    @ConditionalOnBean(value={ShenyuThreadPoolExecutor.class})
    public ShenyuThreadPoolExecutorDestructor shenyuThreadPoolExecutorDestructor() {
        return new ShenyuThreadPoolExecutorDestructor();
    }

    public static class ShenyuThreadPoolExecutorDestructor
    implements ApplicationListener<ContextClosedEvent> {
        public void onApplicationEvent(ContextClosedEvent event) {
            ((ShenyuThreadPoolExecutor)SpringBeanUtils.getInstance().getBean(ShenyuThreadPoolExecutor.class)).shutdown();
        }
    }
}

