/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.instance.nacos;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingFactory;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import java.util.Properties;
import org.apache.shenyu.common.config.ShenyuConfig;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.register.common.dto.InstanceRegisterDTO;
import org.apache.shenyu.register.instance.api.ShenyuInstanceRegisterRepository;
import org.apache.shenyu.spi.Join;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Join
public class NacosInstanceRegisterRepository
implements ShenyuInstanceRegisterRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosInstanceRegisterRepository.class);
    private static final String NAMESPACE = "nacosNameSpace";
    private NamingService namingService;
    private String groupName;
    private String serviceName;

    public void init(ShenyuConfig.InstanceConfig config) {
        Properties properties = config.getProps();
        Properties nacosProperties = new Properties();
        this.groupName = properties.getProperty("groupName", "DEFAULT_GROUP");
        this.serviceName = properties.getProperty("serviceName", "shenyu-instances");
        String serverAddr = config.getServerLists();
        nacosProperties.put("serverAddr", serverAddr);
        nacosProperties.put("namespace", properties.getProperty(NAMESPACE, ""));
        nacosProperties.put("username", properties.getProperty("username", ""));
        nacosProperties.put("password", properties.getProperty("password", ""));
        nacosProperties.put("accessKey", properties.getProperty("accessKey", ""));
        nacosProperties.put("secretKey", properties.getProperty("secretKey", ""));
        try {
            this.namingService = NamingFactory.createNamingService((Properties)nacosProperties);
        }
        catch (NacosException e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    public void persistInstance(InstanceRegisterDTO instance) {
        try {
            Instance inst = new Instance();
            inst.setWeight(1.0);
            inst.setEphemeral(true);
            inst.setIp(instance.getHost());
            inst.setPort(instance.getPort().intValue());
            inst.setInstanceId(this.buildInstanceNodeName(instance));
            inst.setServiceName(instance.getAppName());
            this.namingService.registerInstance(this.serviceName, this.groupName, inst);
            LOGGER.info("nacos client register success: {}", (Object)inst);
        }
        catch (NacosException e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    private String buildInstanceNodeName(InstanceRegisterDTO instance) {
        String host = instance.getHost();
        int port = instance.getPort();
        return String.join((CharSequence)":", host, Integer.toString(port));
    }

    public void close() {
        try {
            this.namingService.shutDown();
        }
        catch (NacosException e) {
            throw new ShenyuException((Throwable)e);
        }
    }
}

