/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.config.springsupport;

import com.weibo.api.motan.config.BasicRefererInterfaceConfig;
import com.weibo.api.motan.config.BasicServiceInterfaceConfig;
import com.weibo.api.motan.config.MethodConfig;
import com.weibo.api.motan.config.ProtocolConfig;
import com.weibo.api.motan.config.RegistryConfig;
import com.weibo.api.motan.config.springsupport.MotanNamespaceHandler;
import com.weibo.api.motan.config.springsupport.ServiceConfigBean;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MotanBeanDefinitionParser
implements BeanDefinitionParser {
    private final Class<?> beanClass;
    private final boolean required;

    public MotanBeanDefinitionParser(Class<?> beanClass, boolean required) {
        this.beanClass = beanClass;
        this.required = required;
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        try {
            return MotanBeanDefinitionParser.parse(element, parserContext, this.beanClass, this.required);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private static BeanDefinition parse(Element element, ParserContext parserContext, Class<?> beanClass, boolean required) throws ClassNotFoundException {
        String name;
        String className;
        RootBeanDefinition bd = new RootBeanDefinition();
        bd.setBeanClass(beanClass);
        bd.setLazyInit(false);
        String id = element.getAttribute("id");
        if ((id == null || id.length() == 0) && required) {
            String generatedBeanName = element.getAttribute("name");
            if (generatedBeanName == null || generatedBeanName.length() == 0) {
                generatedBeanName = element.getAttribute("class");
            }
            if (generatedBeanName == null || generatedBeanName.length() == 0) {
                generatedBeanName = beanClass.getName();
            }
            id = generatedBeanName;
            int counter = 2;
            while (parserContext.getRegistry().containsBeanDefinition(id)) {
                id = generatedBeanName + counter++;
            }
        }
        if (id != null && id.length() > 0) {
            if (parserContext.getRegistry().containsBeanDefinition(id)) {
                throw new IllegalStateException("Duplicate spring bean id " + id);
            }
            parserContext.getRegistry().registerBeanDefinition(id, (BeanDefinition)bd);
        }
        bd.getPropertyValues().addPropertyValue("id", (Object)id);
        if (ProtocolConfig.class.equals(beanClass)) {
            MotanNamespaceHandler.protocolDefineNames.add(id);
        } else if (RegistryConfig.class.equals(beanClass)) {
            MotanNamespaceHandler.registryDefineNames.add(id);
        } else if (BasicServiceInterfaceConfig.class.equals(beanClass)) {
            MotanNamespaceHandler.basicServiceConfigDefineNames.add(id);
        } else if (BasicRefererInterfaceConfig.class.equals(beanClass)) {
            MotanNamespaceHandler.basicRefererConfigDefineNames.add(id);
        } else if (ServiceConfigBean.class.equals(beanClass) && (className = element.getAttribute("class")) != null && className.length() > 0) {
            RootBeanDefinition classDefinition = new RootBeanDefinition();
            classDefinition.setBeanClass(Class.forName(className, true, Thread.currentThread().getContextClassLoader()));
            classDefinition.setLazyInit(false);
            MotanBeanDefinitionParser.parseProperties(element.getChildNodes(), classDefinition);
            bd.getPropertyValues().addPropertyValue("ref", (Object)new BeanDefinitionHolder((BeanDefinition)classDefinition, id + "Impl"));
        }
        HashSet<String> props = new HashSet<String>();
        ManagedMap parameters = null;
        for (Method setter : beanClass.getMethods()) {
            Object reference;
            name = setter.getName();
            if (name.length() <= 3 || !name.startsWith("set") || !Modifier.isPublic(setter.getModifiers()) || setter.getParameterTypes().length != 1) continue;
            String property = (name.substring(3, 4).toLowerCase() + name.substring(4)).replaceAll("_", "-");
            props.add(property);
            if ("id".equals(property)) {
                bd.getPropertyValues().addPropertyValue("id", (Object)id);
                continue;
            }
            String value = element.getAttribute(property);
            if ("methods".equals(property)) {
                MotanBeanDefinitionParser.parseMethods(id, element.getChildNodes(), bd, parserContext);
            }
            if (StringUtils.isBlank((CharSequence)value) || (value = value.trim()).length() == 0) continue;
            if ("ref".equals(property)) {
                BeanDefinition refBean;
                if (parserContext.getRegistry().containsBeanDefinition(value) && !(refBean = parserContext.getRegistry().getBeanDefinition(value)).isSingleton()) {
                    throw new IllegalStateException("The exported service ref " + value + " must be singleton! Please set the " + value + " bean scope to singleton, eg: <bean id=\"" + value + "\" scope=\"singleton\" ...>");
                }
                reference = new RuntimeBeanReference(value);
            } else if ("protocol".equals(property) && !StringUtils.isBlank((CharSequence)value)) {
                if (!value.contains(",")) {
                    reference = new RuntimeBeanReference(value);
                } else {
                    MotanBeanDefinitionParser.parseMultiRef("protocols", value, bd, parserContext);
                    reference = null;
                }
            } else if ("registry".equals(property)) {
                MotanBeanDefinitionParser.parseMultiRef("registries", value, bd, parserContext);
                reference = null;
            } else {
                reference = "basicService".equals(property) || "basicReferer".equals(property) || "extConfig".equals(property) || "proxyRegistry".equals(property) ? new RuntimeBeanReference(value) : new TypedStringValue(value);
            }
            if (reference == null) continue;
            bd.getPropertyValues().addPropertyValue(property, reference);
        }
        if (ProtocolConfig.class.equals(beanClass)) {
            NamedNodeMap attributes = element.getAttributes();
            int len = attributes.getLength();
            for (int i = 0; i < len; ++i) {
                Node node = attributes.item(i);
                name = node.getLocalName();
                if (props.contains(name)) continue;
                if (parameters == null) {
                    parameters = new ManagedMap();
                }
                String value = node.getNodeValue();
                parameters.put((Object)name, (Object)new TypedStringValue(value, String.class));
            }
            bd.getPropertyValues().addPropertyValue("parameters", parameters);
        }
        return bd;
    }

    private static void parseMultiRef(String property, String value, RootBeanDefinition beanDefinition, ParserContext parserContext) {
        String[] values = value.split("\\s*[,]+\\s*");
        ManagedList list = null;
        for (String v : values) {
            if (v == null || v.length() <= 0) continue;
            if (list == null) {
                list = new ManagedList();
            }
            list.add((Object)new RuntimeBeanReference(v));
        }
        beanDefinition.getPropertyValues().addPropertyValue(property, list);
    }

    private static void parseProperties(NodeList nodeList, RootBeanDefinition beanDefinition) {
        if (nodeList != null && nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String name;
                Node node = nodeList.item(i);
                if (!(node instanceof Element) || !"property".equals(node.getNodeName()) && !"property".equals(node.getLocalName()) || (name = ((Element)node).getAttribute("name")) == null || name.length() <= 0) continue;
                String value = ((Element)node).getAttribute("value");
                String ref = ((Element)node).getAttribute("ref");
                if (value != null && value.length() > 0) {
                    beanDefinition.getPropertyValues().addPropertyValue(name, (Object)value);
                    continue;
                }
                if (ref != null && ref.length() > 0) {
                    beanDefinition.getPropertyValues().addPropertyValue(name, (Object)new RuntimeBeanReference(ref));
                    continue;
                }
                throw new UnsupportedOperationException("Unsupported <property name=\"" + name + "\"> sub tag, Only supported <property name=\"" + name + "\" ref=\"...\" /> or <property name=\"" + name + "\" value=\"...\" />");
            }
        }
    }

    private static void parseMethods(String id, NodeList nodeList, RootBeanDefinition beanDefinition, ParserContext parserContext) throws ClassNotFoundException {
        if (nodeList != null && nodeList.getLength() > 0) {
            ManagedList methods = null;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                Element element = (Element)node;
                if (!"method".equals(node.getNodeName()) && !"method".equals(node.getLocalName())) continue;
                String methodName = element.getAttribute("name");
                if (methodName == null || methodName.length() == 0) {
                    throw new IllegalStateException("<motan:method> name attribute == null");
                }
                if (methods == null) {
                    methods = new ManagedList();
                }
                BeanDefinition methodBeanDefinition = MotanBeanDefinitionParser.parse((Element)node, parserContext, MethodConfig.class, false);
                String name = id + "." + methodName;
                BeanDefinitionHolder methodBeanDefinitionHolder = new BeanDefinitionHolder(methodBeanDefinition, name);
                methods.add((Object)methodBeanDefinitionHolder);
            }
            if (methods != null) {
                beanDefinition.getPropertyValues().addPropertyValue("methods", methods);
            }
        }
    }
}

