/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.motan.proxy;

import com.weibo.api.motan.proxy.CommonHandler;
import com.weibo.api.motan.rpc.ResponseFuture;
import com.weibo.api.motan.rpc.RpcContext;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.concurrent.ShenyuThreadFactory;
import org.apache.shenyu.common.concurrent.ShenyuThreadPoolExecutor;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.convert.plugin.MotanRegisterConfig;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.ResultEnum;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.plugin.api.utils.SpringBeanUtils;
import org.apache.shenyu.plugin.motan.cache.ApplicationConfigCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class MotanProxyService {
    private static final Logger LOG = LoggerFactory.getLogger(MotanProxyService.class);
    private final ThreadFactory factory = ShenyuThreadFactory.create((String)"shenyu-motan", (boolean)true);
    private ExecutorService threadPool;

    public Mono<Object> genericInvoker(String body, MetaData metaData, ServerWebExchange exchange) throws ShenyuException {
        ResponseFuture responseFuture;
        Object[] params;
        Map rpcContext = (Map)exchange.getAttribute("generalContext");
        Optional.ofNullable(rpcContext).map(context -> (Map)context.get(PluginEnum.MOTAN.getName())).ifPresent(context -> context.forEach((k, v) -> RpcContext.getContext().setRpcAttachment(k, v)));
        Object reference = ApplicationConfigCache.getInstance().get(metaData.getPath());
        if (Objects.isNull(reference) || StringUtils.isEmpty((CharSequence)reference.getServiceInterface())) {
            ApplicationConfigCache.getInstance().invalidate(metaData.getPath());
            reference = ApplicationConfigCache.getInstance().initRef(metaData);
        }
        CommonHandler commonHandler = (CommonHandler)reference.getRef();
        ApplicationConfigCache.MotanParamInfo motanParamInfo = (ApplicationConfigCache.MotanParamInfo)ApplicationConfigCache.PARAM_MAP.get(metaData.getMethodName());
        if (Objects.isNull(motanParamInfo)) {
            params = new Object[]{};
        } else {
            int num = motanParamInfo.getParamTypes().length;
            params = new Object[num];
            Map bodyMap = GsonUtils.getInstance().convertToMap(body);
            for (int i = 0; i < num; ++i) {
                params[i] = bodyMap.get(motanParamInfo.getParamNames()[i]).toString();
            }
        }
        try {
            responseFuture = (ResponseFuture)commonHandler.asyncCall(metaData.getMethodName(), params, Object.class);
        }
        catch (Throwable e) {
            LOG.error("Exception caught in MotanProxyService#genericInvoker.", e);
            return null;
        }
        this.initThreadPool();
        CompletableFuture<Object> future = CompletableFuture.supplyAsync(() -> ((ResponseFuture)responseFuture).getValue(), this.threadPool);
        return Mono.fromFuture((CompletableFuture)future.thenApply(ret -> {
            if (Objects.isNull(ret)) {
                ret = "motan has not return value!";
            }
            exchange.getAttributes().put("rpc_result", ret);
            exchange.getAttributes().put("webHandlerClientResponseResultType", ResultEnum.SUCCESS.getName());
            return ret;
        })).onErrorMap(ShenyuException::new);
    }

    private void initThreadPool() {
        String threadpool;
        if (Objects.nonNull(this.threadPool)) {
            return;
        }
        MotanRegisterConfig config = (MotanRegisterConfig)Singleton.INST.get(MotanRegisterConfig.class);
        if (Objects.isNull(config)) {
            this.threadPool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), this.factory);
            return;
        }
        switch (threadpool = Optional.ofNullable(config.getThreadpool()).orElse("cached")) {
            case "shared": {
                try {
                    this.threadPool = (ExecutorService)SpringBeanUtils.getInstance().getBean(ShenyuThreadPoolExecutor.class);
                    return;
                }
                catch (NoSuchBeanDefinitionException t) {
                    throw new ShenyuException("shared thread pool is not enable, config ${shenyu.sharedPool.enable} in your xml/yml !", (Throwable)t);
                }
            }
            case "fixed": 
            case "eager": 
            case "limited": {
                throw new UnsupportedOperationException();
            }
        }
        int corePoolSize = Optional.ofNullable(config.getCorethreads()).orElse(0);
        int maximumPoolSize = Optional.ofNullable(config.getThreads()).orElse(Integer.MAX_VALUE);
        int queueSize = Optional.ofNullable(config.getQueues()).orElse(0);
        this.threadPool = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)((Object)(queueSize > 0 ? new LinkedBlockingQueue(queueSize) : new SynchronousQueue())), this.factory);
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }
}

