/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.cryptor.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.cryptor.utils.JsonUtil;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public final class CryptorUtil {
    private CryptorUtil() {
    }

    public static Mono<Void> fail(String mode, ServerWebExchange exchange) {
        Object error = Optional.ofNullable(mode).filter("decrypt"::equals).map(mod -> ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.DECRYPTION_ERROR)).orElse(ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.ENCRYPTION_ERROR));
        return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
    }

    public static Mono<String> success(String originalBody, String modifiedBody, String way, String fieldNames) {
        if ("decrypt".equals(way)) {
            return Mono.just((Object)modifiedBody);
        }
        AtomicInteger initDeep = new AtomicInteger();
        initDeep.set(0);
        JsonElement je = new JsonParser().parse(originalBody);
        JsonElement resultJe = JsonUtil.replaceJsonNode(je, initDeep, modifiedBody, Arrays.asList(fieldNames.split("\\.")));
        return Mono.just((Object)resultJe.toString());
    }
}

