/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.sync.data.websocket.client;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.shenyu.common.dto.WebsocketData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.timer.AbstractRoundTask;
import org.apache.shenyu.common.timer.Timer;
import org.apache.shenyu.common.timer.TimerTask;
import org.apache.shenyu.common.timer.WheelTimerFactory;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.plugin.sync.data.websocket.handler.WebsocketDataHandler;
import org.apache.shenyu.sync.data.api.AuthDataSubscriber;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShenyuWebsocketClient
extends WebSocketClient {
    private static final Logger LOG = LoggerFactory.getLogger(ShenyuWebsocketClient.class);
    private volatile boolean alreadySync = Boolean.FALSE;
    private final WebsocketDataHandler websocketDataHandler;
    private final Timer timer;
    private TimerTask timerTask;

    public ShenyuWebsocketClient(URI serverUri, PluginDataSubscriber pluginDataSubscriber, List<MetaDataSubscriber> metaDataSubscribers, List<AuthDataSubscriber> authDataSubscribers) {
        super(serverUri);
        this.websocketDataHandler = new WebsocketDataHandler(pluginDataSubscriber, metaDataSubscribers, authDataSubscribers);
        this.timer = WheelTimerFactory.getSharedTimer();
        this.connection();
    }

    public ShenyuWebsocketClient(URI serverUri, Map<String, String> headers, PluginDataSubscriber pluginDataSubscriber, List<MetaDataSubscriber> metaDataSubscribers, List<AuthDataSubscriber> authDataSubscribers) {
        super(serverUri, headers);
        this.websocketDataHandler = new WebsocketDataHandler(pluginDataSubscriber, metaDataSubscribers, authDataSubscribers);
        this.timer = WheelTimerFactory.getSharedTimer();
        this.connection();
    }

    private void connection() {
        this.connectBlocking();
        this.timerTask = new AbstractRoundTask(null, TimeUnit.SECONDS.toMillis(10L)){

            public void doRun(String key, TimerTask timerTask) {
                ShenyuWebsocketClient.this.healthCheck();
            }
        };
        this.timer.add(this.timerTask);
    }

    public boolean connectBlocking() {
        boolean success = false;
        try {
            success = super.connectBlocking();
        }
        catch (Exception exception) {
            LOG.error("websocket connection server[{}] is error.....[{}]", (Object)this.getURI().toString(), (Object)exception.getMessage());
        }
        if (success) {
            LOG.info("websocket connection server[{}] is successful.....", (Object)this.getURI().toString());
        } else {
            LOG.warn("websocket connection server[{}] is error.....", (Object)this.getURI().toString());
        }
        return success;
    }

    public void onOpen(ServerHandshake serverHandshake) {
        if (!this.alreadySync) {
            this.send(DataEventTypeEnum.MYSELF.name());
            this.alreadySync = true;
        }
    }

    public void onMessage(String result) {
        this.handleResult(result);
    }

    public void onClose(int i, String s, boolean b) {
        this.close();
    }

    public void onError(Exception e) {
        LOG.error("websocket server[{}] is error.....", (Object)this.getURI(), (Object)e);
    }

    public void close() {
        this.alreadySync = false;
        if (this.isOpen()) {
            super.close();
        }
    }

    public void nowClose() {
        this.close();
        this.timerTask.cancel();
    }

    private void healthCheck() {
        try {
            if (!this.isOpen()) {
                this.reconnectBlocking();
            } else {
                this.sendPing();
                LOG.debug("websocket send to [{}] ping message successful", (Object)this.getURI());
            }
        }
        catch (Exception e) {
            LOG.error("websocket connect is error :{}", (Object)e.getMessage());
        }
    }

    private void handleResult(String result) {
        LOG.info("handleResult({})", (Object)result);
        WebsocketData websocketData = (WebsocketData)GsonUtils.getInstance().fromJson(result, WebsocketData.class);
        ConfigGroupEnum groupEnum = ConfigGroupEnum.acquireByName((String)websocketData.getGroupType());
        String eventType = websocketData.getEventType();
        String json = GsonUtils.getInstance().toJson((Object)websocketData.getData());
        this.websocketDataHandler.executor(groupEnum, json, eventType);
    }
}

