/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.json.jackson;

import co.elastic.clients.json.jackson.JacksonJsonpLocation;
import co.elastic.clients.json.jackson.JsonValueParser;
import com.fasterxml.jackson.core.JsonToken;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonLocation;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParsingException;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.EnumMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Stream;

public class JacksonJsonpParser
implements JsonParser {
    private final com.fasterxml.jackson.core.JsonParser parser;
    private boolean hasNextWasCalled = false;
    private static final EnumMap<JsonToken, JsonParser.Event> tokenToEvent = new EnumMap(JsonToken.class);
    private JsonValueParser valueParser;

    public JacksonJsonpParser(com.fasterxml.jackson.core.JsonParser parser) {
        this.parser = parser;
    }

    public com.fasterxml.jackson.core.JsonParser jacksonParser() {
        return this.parser;
    }

    private JsonParsingException convertException(IOException ioe) {
        return new JsonParsingException("Jackson exception: " + ioe.getMessage(), (Throwable)ioe, this.getLocation());
    }

    private JsonToken fetchNextToken() {
        try {
            return this.parser.nextToken();
        }
        catch (IOException e) {
            throw this.convertException(e);
        }
    }

    private void ensureTokenIsCurrent() {
        if (this.hasNextWasCalled) {
            throw new IllegalStateException("Cannot get event data as parser as already been moved to the next event");
        }
    }

    public boolean hasNext() {
        if (this.hasNextWasCalled) {
            return this.parser.currentToken() != null;
        }
        this.hasNextWasCalled = true;
        return this.fetchNextToken() != null;
    }

    public JsonParser.Event next() {
        JsonToken token;
        if (this.hasNextWasCalled) {
            token = this.parser.getCurrentToken();
            this.hasNextWasCalled = false;
        } else {
            token = this.fetchNextToken();
        }
        if (token == null) {
            throw new NoSuchElementException();
        }
        JsonParser.Event result = tokenToEvent.get(token);
        if (result == null) {
            throw new JsonParsingException("Unsupported Jackson event type '" + token + "'", this.getLocation());
        }
        return result;
    }

    public String getString() {
        this.ensureTokenIsCurrent();
        try {
            return this.parser.getValueAsString();
        }
        catch (IOException e) {
            throw this.convertException(e);
        }
    }

    public boolean isIntegralNumber() {
        this.ensureTokenIsCurrent();
        return this.parser.isExpectedNumberIntToken();
    }

    public int getInt() {
        this.ensureTokenIsCurrent();
        try {
            return this.parser.getIntValue();
        }
        catch (IOException e) {
            throw this.convertException(e);
        }
    }

    public long getLong() {
        this.ensureTokenIsCurrent();
        try {
            return this.parser.getLongValue();
        }
        catch (IOException e) {
            throw this.convertException(e);
        }
    }

    public BigDecimal getBigDecimal() {
        this.ensureTokenIsCurrent();
        try {
            return this.parser.getDecimalValue();
        }
        catch (IOException e) {
            throw this.convertException(e);
        }
    }

    public JsonLocation getLocation() {
        return new JacksonJsonpLocation(this.parser.getCurrentLocation());
    }

    public void close() {
        try {
            this.parser.close();
        }
        catch (IOException e) {
            throw this.convertException(e);
        }
    }

    public JsonObject getObject() {
        this.ensureTokenIsCurrent();
        if (this.parser.currentToken() != JsonToken.START_OBJECT) {
            throw new IllegalStateException("Unexpected event '" + this.parser.currentToken() + "' at " + this.parser.getTokenLocation());
        }
        if (this.valueParser == null) {
            this.valueParser = new JsonValueParser();
        }
        try {
            return this.valueParser.parseObject(this.parser);
        }
        catch (IOException e) {
            throw this.convertException(e);
        }
    }

    public JsonArray getArray() {
        this.ensureTokenIsCurrent();
        if (this.valueParser == null) {
            this.valueParser = new JsonValueParser();
        }
        if (this.parser.currentToken() != JsonToken.START_ARRAY) {
            throw new IllegalStateException("Unexpected event '" + this.parser.currentToken() + "' at " + this.parser.getTokenLocation());
        }
        try {
            return this.valueParser.parseArray(this.parser);
        }
        catch (IOException e) {
            throw this.convertException(e);
        }
    }

    public JsonValue getValue() {
        this.ensureTokenIsCurrent();
        if (this.valueParser == null) {
            this.valueParser = new JsonValueParser();
        }
        try {
            return this.valueParser.parseValue(this.parser);
        }
        catch (IOException e) {
            throw this.convertException(e);
        }
    }

    public void skipObject() {
        this.ensureTokenIsCurrent();
        if (this.parser.currentToken() != JsonToken.START_OBJECT) {
            return;
        }
        try {
            JsonToken token;
            int depth = 1;
            do {
                token = this.parser.nextToken();
                switch (token) {
                    case START_OBJECT: {
                        ++depth;
                        break;
                    }
                    case END_OBJECT: {
                        --depth;
                    }
                }
            } while (token != JsonToken.END_OBJECT || depth != 0);
        }
        catch (IOException e) {
            throw this.convertException(e);
        }
    }

    public void skipArray() {
        this.ensureTokenIsCurrent();
        if (this.parser.currentToken() != JsonToken.START_ARRAY) {
            return;
        }
        try {
            JsonToken token;
            int depth = 1;
            do {
                token = this.parser.nextToken();
                switch (token) {
                    case START_ARRAY: {
                        ++depth;
                        break;
                    }
                    case END_ARRAY: {
                        --depth;
                    }
                }
            } while (token != JsonToken.END_ARRAY || depth != 0);
        }
        catch (IOException e) {
            throw this.convertException(e);
        }
    }

    public Stream<Map.Entry<String, JsonValue>> getObjectStream() {
        return this.getObject().entrySet().stream();
    }

    public Stream<JsonValue> getArrayStream() {
        return this.getArray().stream();
    }

    public Stream<JsonValue> getValueStream() {
        return super.getValueStream();
    }

    static {
        tokenToEvent.put(JsonToken.END_ARRAY, JsonParser.Event.END_ARRAY);
        tokenToEvent.put(JsonToken.END_OBJECT, JsonParser.Event.END_OBJECT);
        tokenToEvent.put(JsonToken.FIELD_NAME, JsonParser.Event.KEY_NAME);
        tokenToEvent.put(JsonToken.START_ARRAY, JsonParser.Event.START_ARRAY);
        tokenToEvent.put(JsonToken.START_OBJECT, JsonParser.Event.START_OBJECT);
        tokenToEvent.put(JsonToken.VALUE_FALSE, JsonParser.Event.VALUE_FALSE);
        tokenToEvent.put(JsonToken.VALUE_NULL, JsonParser.Event.VALUE_NULL);
        tokenToEvent.put(JsonToken.VALUE_NUMBER_FLOAT, JsonParser.Event.VALUE_NUMBER);
        tokenToEvent.put(JsonToken.VALUE_NUMBER_INT, JsonParser.Event.VALUE_NUMBER);
        tokenToEvent.put(JsonToken.VALUE_STRING, JsonParser.Event.VALUE_STRING);
        tokenToEvent.put(JsonToken.VALUE_TRUE, JsonParser.Event.VALUE_TRUE);
    }
}

