/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.NlpInferenceConfigUpdate;
import co.elastic.clients.elasticsearch.ml.NlpInferenceConfigUpdateVariant;
import co.elastic.clients.elasticsearch.ml.NlpTokenizationUpdateOptions;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TextClassificationInferenceUpdateOptions
implements NlpInferenceConfigUpdateVariant,
JsonpSerializable {
    @Nullable
    private final Integer numTopClasses;
    @Nullable
    private final NlpTokenizationUpdateOptions tokenization;
    @Nullable
    private final String resultsField;
    private final List<String> classificationLabels;
    public static final JsonpDeserializer<TextClassificationInferenceUpdateOptions> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TextClassificationInferenceUpdateOptions::setupTextClassificationInferenceUpdateOptionsDeserializer);

    private TextClassificationInferenceUpdateOptions(Builder builder) {
        this.numTopClasses = builder.numTopClasses;
        this.tokenization = builder.tokenization;
        this.resultsField = builder.resultsField;
        this.classificationLabels = ApiTypeHelper.unmodifiable(builder.classificationLabels);
    }

    public static TextClassificationInferenceUpdateOptions of(Function<Builder, ObjectBuilder<TextClassificationInferenceUpdateOptions>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public NlpInferenceConfigUpdate.Kind _nlpInferenceConfigUpdateKind() {
        return NlpInferenceConfigUpdate.Kind.TextClassification;
    }

    @Nullable
    public final Integer numTopClasses() {
        return this.numTopClasses;
    }

    @Nullable
    public final NlpTokenizationUpdateOptions tokenization() {
        return this.tokenization;
    }

    @Nullable
    public final String resultsField() {
        return this.resultsField;
    }

    public final List<String> classificationLabels() {
        return this.classificationLabels;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.numTopClasses != null) {
            generator.writeKey("num_top_classes");
            generator.write(this.numTopClasses.intValue());
        }
        if (this.tokenization != null) {
            generator.writeKey("tokenization");
            this.tokenization.serialize(generator, mapper);
        }
        if (this.resultsField != null) {
            generator.writeKey("results_field");
            generator.write(this.resultsField);
        }
        if (ApiTypeHelper.isDefined(this.classificationLabels)) {
            generator.writeKey("classification_labels");
            generator.writeStartArray();
            for (String item0 : this.classificationLabels) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTextClassificationInferenceUpdateOptionsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::numTopClasses, JsonpDeserializer.integerDeserializer(), "num_top_classes");
        op.add(Builder::tokenization, NlpTokenizationUpdateOptions._DESERIALIZER, "tokenization");
        op.add(Builder::resultsField, JsonpDeserializer.stringDeserializer(), "results_field");
        op.add(Builder::classificationLabels, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "classification_labels");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TextClassificationInferenceUpdateOptions> {
        @Nullable
        private Integer numTopClasses;
        @Nullable
        private NlpTokenizationUpdateOptions tokenization;
        @Nullable
        private String resultsField;
        @Nullable
        private List<String> classificationLabels;

        public final Builder numTopClasses(@Nullable Integer value) {
            this.numTopClasses = value;
            return this;
        }

        public final Builder tokenization(@Nullable NlpTokenizationUpdateOptions value) {
            this.tokenization = value;
            return this;
        }

        public final Builder tokenization(Function<NlpTokenizationUpdateOptions.Builder, ObjectBuilder<NlpTokenizationUpdateOptions>> fn) {
            return this.tokenization(fn.apply(new NlpTokenizationUpdateOptions.Builder()).build());
        }

        public final Builder resultsField(@Nullable String value) {
            this.resultsField = value;
            return this;
        }

        public final Builder classificationLabels(List<String> list) {
            this.classificationLabels = Builder._listAddAll(this.classificationLabels, list);
            return this;
        }

        public final Builder classificationLabels(String value, String ... values) {
            this.classificationLabels = Builder._listAdd(this.classificationLabels, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TextClassificationInferenceUpdateOptions build() {
            this._checkSingleUse();
            return new TextClassificationInferenceUpdateOptions(this);
        }
    }
}

