/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class RunningStateSearchInterval
implements JsonpSerializable {
    private final long endMs;
    private final long startMs;
    public static final JsonpDeserializer<RunningStateSearchInterval> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RunningStateSearchInterval::setupRunningStateSearchIntervalDeserializer);

    private RunningStateSearchInterval(Builder builder) {
        this.endMs = ApiTypeHelper.requireNonNull(builder.endMs, this, "endMs");
        this.startMs = ApiTypeHelper.requireNonNull(builder.startMs, this, "startMs");
    }

    public static RunningStateSearchInterval of(Function<Builder, ObjectBuilder<RunningStateSearchInterval>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long endMs() {
        return this.endMs;
    }

    public final long startMs() {
        return this.startMs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("end_ms");
        generator.write(this.endMs);
        generator.writeKey("start_ms");
        generator.write(this.startMs);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRunningStateSearchIntervalDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::endMs, JsonpDeserializer.longDeserializer(), "end_ms");
        op.add(Builder::startMs, JsonpDeserializer.longDeserializer(), "start_ms");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RunningStateSearchInterval> {
        private Long endMs;
        private Long startMs;

        public final Builder endMs(long value) {
            this.endMs = value;
            return this;
        }

        public final Builder startMs(long value) {
            this.startMs = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RunningStateSearchInterval build() {
            this._checkSingleUse();
            return new RunningStateSearchInterval(this);
        }
    }
}

