/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DataframeAnalysisFeatureProcessorFrequencyEncoding;
import co.elastic.clients.elasticsearch.ml.DataframeAnalysisFeatureProcessorMultiEncoding;
import co.elastic.clients.elasticsearch.ml.DataframeAnalysisFeatureProcessorNGramEncoding;
import co.elastic.clients.elasticsearch.ml.DataframeAnalysisFeatureProcessorOneHotEncoding;
import co.elastic.clients.elasticsearch.ml.DataframeAnalysisFeatureProcessorTargetMeanEncoding;
import co.elastic.clients.elasticsearch.ml.DataframeAnalysisFeatureProcessorVariant;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class DataframeAnalysisFeatureProcessor
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<DataframeAnalysisFeatureProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataframeAnalysisFeatureProcessor::setupDataframeAnalysisFeatureProcessorDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public DataframeAnalysisFeatureProcessor(DataframeAnalysisFeatureProcessorVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._dataframeAnalysisFeatureProcessorKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private DataframeAnalysisFeatureProcessor(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static DataframeAnalysisFeatureProcessor of(Function<Builder, ObjectBuilder<DataframeAnalysisFeatureProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isFrequencyEncoding() {
        return this._kind == Kind.FrequencyEncoding;
    }

    public DataframeAnalysisFeatureProcessorFrequencyEncoding frequencyEncoding() {
        return (DataframeAnalysisFeatureProcessorFrequencyEncoding)TaggedUnionUtils.get(this, Kind.FrequencyEncoding);
    }

    public boolean isMultiEncoding() {
        return this._kind == Kind.MultiEncoding;
    }

    public DataframeAnalysisFeatureProcessorMultiEncoding multiEncoding() {
        return (DataframeAnalysisFeatureProcessorMultiEncoding)TaggedUnionUtils.get(this, Kind.MultiEncoding);
    }

    public boolean isNGramEncoding() {
        return this._kind == Kind.NGramEncoding;
    }

    public DataframeAnalysisFeatureProcessorNGramEncoding nGramEncoding() {
        return (DataframeAnalysisFeatureProcessorNGramEncoding)TaggedUnionUtils.get(this, Kind.NGramEncoding);
    }

    public boolean isOneHotEncoding() {
        return this._kind == Kind.OneHotEncoding;
    }

    public DataframeAnalysisFeatureProcessorOneHotEncoding oneHotEncoding() {
        return (DataframeAnalysisFeatureProcessorOneHotEncoding)TaggedUnionUtils.get(this, Kind.OneHotEncoding);
    }

    public boolean isTargetMeanEncoding() {
        return this._kind == Kind.TargetMeanEncoding;
    }

    public DataframeAnalysisFeatureProcessorTargetMeanEncoding targetMeanEncoding() {
        return (DataframeAnalysisFeatureProcessorTargetMeanEncoding)TaggedUnionUtils.get(this, Kind.TargetMeanEncoding);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupDataframeAnalysisFeatureProcessorDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::frequencyEncoding, DataframeAnalysisFeatureProcessorFrequencyEncoding._DESERIALIZER, "frequency_encoding");
        op.add(Builder::multiEncoding, DataframeAnalysisFeatureProcessorMultiEncoding._DESERIALIZER, "multi_encoding");
        op.add(Builder::nGramEncoding, DataframeAnalysisFeatureProcessorNGramEncoding._DESERIALIZER, "n_gram_encoding");
        op.add(Builder::oneHotEncoding, DataframeAnalysisFeatureProcessorOneHotEncoding._DESERIALIZER, "one_hot_encoding");
        op.add(Builder::targetMeanEncoding, DataframeAnalysisFeatureProcessorTargetMeanEncoding._DESERIALIZER, "target_mean_encoding");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DataframeAnalysisFeatureProcessor> {
        private Kind _kind;
        private Object _value;

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<DataframeAnalysisFeatureProcessor> frequencyEncoding(DataframeAnalysisFeatureProcessorFrequencyEncoding v) {
            this._kind = Kind.FrequencyEncoding;
            this._value = v;
            return this;
        }

        public ObjectBuilder<DataframeAnalysisFeatureProcessor> frequencyEncoding(Function<DataframeAnalysisFeatureProcessorFrequencyEncoding.Builder, ObjectBuilder<DataframeAnalysisFeatureProcessorFrequencyEncoding>> fn) {
            return this.frequencyEncoding(fn.apply(new DataframeAnalysisFeatureProcessorFrequencyEncoding.Builder()).build());
        }

        public ObjectBuilder<DataframeAnalysisFeatureProcessor> multiEncoding(DataframeAnalysisFeatureProcessorMultiEncoding v) {
            this._kind = Kind.MultiEncoding;
            this._value = v;
            return this;
        }

        public ObjectBuilder<DataframeAnalysisFeatureProcessor> multiEncoding(Function<DataframeAnalysisFeatureProcessorMultiEncoding.Builder, ObjectBuilder<DataframeAnalysisFeatureProcessorMultiEncoding>> fn) {
            return this.multiEncoding(fn.apply(new DataframeAnalysisFeatureProcessorMultiEncoding.Builder()).build());
        }

        public ObjectBuilder<DataframeAnalysisFeatureProcessor> nGramEncoding(DataframeAnalysisFeatureProcessorNGramEncoding v) {
            this._kind = Kind.NGramEncoding;
            this._value = v;
            return this;
        }

        public ObjectBuilder<DataframeAnalysisFeatureProcessor> nGramEncoding(Function<DataframeAnalysisFeatureProcessorNGramEncoding.Builder, ObjectBuilder<DataframeAnalysisFeatureProcessorNGramEncoding>> fn) {
            return this.nGramEncoding(fn.apply(new DataframeAnalysisFeatureProcessorNGramEncoding.Builder()).build());
        }

        public ObjectBuilder<DataframeAnalysisFeatureProcessor> oneHotEncoding(DataframeAnalysisFeatureProcessorOneHotEncoding v) {
            this._kind = Kind.OneHotEncoding;
            this._value = v;
            return this;
        }

        public ObjectBuilder<DataframeAnalysisFeatureProcessor> oneHotEncoding(Function<DataframeAnalysisFeatureProcessorOneHotEncoding.Builder, ObjectBuilder<DataframeAnalysisFeatureProcessorOneHotEncoding>> fn) {
            return this.oneHotEncoding(fn.apply(new DataframeAnalysisFeatureProcessorOneHotEncoding.Builder()).build());
        }

        public ObjectBuilder<DataframeAnalysisFeatureProcessor> targetMeanEncoding(DataframeAnalysisFeatureProcessorTargetMeanEncoding v) {
            this._kind = Kind.TargetMeanEncoding;
            this._value = v;
            return this;
        }

        public ObjectBuilder<DataframeAnalysisFeatureProcessor> targetMeanEncoding(Function<DataframeAnalysisFeatureProcessorTargetMeanEncoding.Builder, ObjectBuilder<DataframeAnalysisFeatureProcessorTargetMeanEncoding>> fn) {
            return this.targetMeanEncoding(fn.apply(new DataframeAnalysisFeatureProcessorTargetMeanEncoding.Builder()).build());
        }

        @Override
        public DataframeAnalysisFeatureProcessor build() {
            this._checkSingleUse();
            return new DataframeAnalysisFeatureProcessor(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        FrequencyEncoding("frequency_encoding"),
        MultiEncoding("multi_encoding"),
        NGramEncoding("n_gram_encoding"),
        OneHotEncoding("one_hot_encoding"),
        TargetMeanEncoding("target_mean_encoding");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

