/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.CategorizationAnalyzerDefinition;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.UnionDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class CategorizationAnalyzer
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<CategorizationAnalyzer> _DESERIALIZER = JsonpDeserializer.lazy(CategorizationAnalyzer::buildCategorizationAnalyzerDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private CategorizationAnalyzer(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    private CategorizationAnalyzer(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static CategorizationAnalyzer of(Function<Builder, ObjectBuilder<CategorizationAnalyzer>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isName() {
        return this._kind == Kind.Name;
    }

    public String name() {
        return (String)TaggedUnionUtils.get(this, Kind.Name);
    }

    public boolean isDefinition() {
        return this._kind == Kind.Definition;
    }

    public CategorizationAnalyzerDefinition definition() {
        return (CategorizationAnalyzerDefinition)TaggedUnionUtils.get(this, Kind.Definition);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind) {
                case Name: {
                    generator.write((String)this._value);
                }
            }
        }
    }

    private static JsonpDeserializer<CategorizationAnalyzer> buildCategorizationAnalyzerDeserializer() {
        return new UnionDeserializer.Builder<CategorizationAnalyzer, Kind, Object>(CategorizationAnalyzer::new, false).addMember(Kind.Name, JsonpDeserializer.stringDeserializer()).addMember(Kind.Definition, CategorizationAnalyzerDefinition._DESERIALIZER).build();
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<CategorizationAnalyzer> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<CategorizationAnalyzer> name(String v) {
            this._kind = Kind.Name;
            this._value = v;
            return this;
        }

        public ObjectBuilder<CategorizationAnalyzer> definition(CategorizationAnalyzerDefinition v) {
            this._kind = Kind.Definition;
            this._value = v;
            return this;
        }

        public ObjectBuilder<CategorizationAnalyzer> definition(Function<CategorizationAnalyzerDefinition.Builder, ObjectBuilder<CategorizationAnalyzerDefinition>> fn) {
            return this.definition(fn.apply(new CategorizationAnalyzerDefinition.Builder()).build());
        }

        @Override
        public CategorizationAnalyzer build() {
            this._checkSingleUse();
            return new CategorizationAnalyzer(this);
        }
    }

    public static enum Kind {
        Name,
        Definition;

    }
}

