/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.elasticsearch.ingest.ShapeType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class CircleProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final double errorDistance;
    private final String field;
    private final boolean ignoreMissing;
    private final ShapeType shapeType;
    private final String targetField;
    public static final JsonpDeserializer<CircleProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CircleProcessor::setupCircleProcessorDeserializer);

    private CircleProcessor(Builder builder) {
        super(builder);
        this.errorDistance = ApiTypeHelper.requireNonNull(builder.errorDistance, this, "errorDistance");
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.ignoreMissing = ApiTypeHelper.requireNonNull(builder.ignoreMissing, this, "ignoreMissing");
        this.shapeType = ApiTypeHelper.requireNonNull(builder.shapeType, this, "shapeType");
        this.targetField = ApiTypeHelper.requireNonNull(builder.targetField, this, "targetField");
    }

    public static CircleProcessor of(Function<Builder, ObjectBuilder<CircleProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Circle;
    }

    public final double errorDistance() {
        return this.errorDistance;
    }

    public final String field() {
        return this.field;
    }

    public final boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    public final ShapeType shapeType() {
        return this.shapeType;
    }

    public final String targetField() {
        return this.targetField;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("error_distance");
        generator.write(this.errorDistance);
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("ignore_missing");
        generator.write(this.ignoreMissing);
        generator.writeKey("shape_type");
        this.shapeType.serialize(generator, mapper);
        generator.writeKey("target_field");
        generator.write(this.targetField);
    }

    protected static void setupCircleProcessorDeserializer(ObjectDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::errorDistance, JsonpDeserializer.doubleDeserializer(), "error_distance");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing");
        op.add(Builder::shapeType, ShapeType._DESERIALIZER, "shape_type");
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field");
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<CircleProcessor> {
        private Double errorDistance;
        private String field;
        private Boolean ignoreMissing;
        private ShapeType shapeType;
        private String targetField;

        public final Builder errorDistance(double value) {
            this.errorDistance = value;
            return this;
        }

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder ignoreMissing(boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        public final Builder shapeType(ShapeType value) {
            this.shapeType = value;
            return this;
        }

        public final Builder targetField(String value) {
            this.targetField = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CircleProcessor build() {
            this._checkSingleUse();
            return new CircleProcessor(this);
        }
    }
}

