/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.rollover;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RolloverConditions
implements JsonpSerializable {
    @Nullable
    private final Time maxAge;
    @Nullable
    private final Long maxDocs;
    @Nullable
    private final String maxSize;
    @Nullable
    private final String maxSizeBytes;
    @Nullable
    private final String maxPrimaryShardSize;
    @Nullable
    private final String maxPrimaryShardSizeBytes;
    @Nullable
    private final DateTime maxAgeMillis;
    public static final JsonpDeserializer<RolloverConditions> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RolloverConditions::setupRolloverConditionsDeserializer);

    private RolloverConditions(Builder builder) {
        this.maxAge = builder.maxAge;
        this.maxDocs = builder.maxDocs;
        this.maxSize = builder.maxSize;
        this.maxSizeBytes = builder.maxSizeBytes;
        this.maxPrimaryShardSize = builder.maxPrimaryShardSize;
        this.maxPrimaryShardSizeBytes = builder.maxPrimaryShardSizeBytes;
        this.maxAgeMillis = builder.maxAgeMillis;
    }

    public static RolloverConditions of(Function<Builder, ObjectBuilder<RolloverConditions>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time maxAge() {
        return this.maxAge;
    }

    @Nullable
    public final Long maxDocs() {
        return this.maxDocs;
    }

    @Nullable
    public final String maxSize() {
        return this.maxSize;
    }

    @Nullable
    public final String maxSizeBytes() {
        return this.maxSizeBytes;
    }

    @Nullable
    public final String maxPrimaryShardSize() {
        return this.maxPrimaryShardSize;
    }

    @Nullable
    public final String maxPrimaryShardSizeBytes() {
        return this.maxPrimaryShardSizeBytes;
    }

    @Nullable
    public final DateTime maxAgeMillis() {
        return this.maxAgeMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.maxAge != null) {
            generator.writeKey("max_age");
            this.maxAge.serialize(generator, mapper);
        }
        if (this.maxDocs != null) {
            generator.writeKey("max_docs");
            generator.write(this.maxDocs.longValue());
        }
        if (this.maxSize != null) {
            generator.writeKey("max_size");
            generator.write(this.maxSize);
        }
        if (this.maxSizeBytes != null) {
            generator.writeKey("max_size_bytes");
            generator.write(this.maxSizeBytes);
        }
        if (this.maxPrimaryShardSize != null) {
            generator.writeKey("max_primary_shard_size");
            generator.write(this.maxPrimaryShardSize);
        }
        if (this.maxPrimaryShardSizeBytes != null) {
            generator.writeKey("max_primary_shard_size_bytes");
            generator.write(this.maxPrimaryShardSizeBytes);
        }
        if (this.maxAgeMillis != null) {
            generator.writeKey("max_age_millis");
            this.maxAgeMillis.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRolloverConditionsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::maxAge, Time._DESERIALIZER, "max_age");
        op.add(Builder::maxDocs, JsonpDeserializer.longDeserializer(), "max_docs");
        op.add(Builder::maxSize, JsonpDeserializer.stringDeserializer(), "max_size");
        op.add(Builder::maxSizeBytes, JsonpDeserializer.stringDeserializer(), "max_size_bytes");
        op.add(Builder::maxPrimaryShardSize, JsonpDeserializer.stringDeserializer(), "max_primary_shard_size");
        op.add(Builder::maxPrimaryShardSizeBytes, JsonpDeserializer.stringDeserializer(), "max_primary_shard_size_bytes");
        op.add(Builder::maxAgeMillis, DateTime._DESERIALIZER, "max_age_millis");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RolloverConditions> {
        @Nullable
        private Time maxAge;
        @Nullable
        private Long maxDocs;
        @Nullable
        private String maxSize;
        @Nullable
        private String maxSizeBytes;
        @Nullable
        private String maxPrimaryShardSize;
        @Nullable
        private String maxPrimaryShardSizeBytes;
        @Nullable
        private DateTime maxAgeMillis;

        public final Builder maxAge(@Nullable Time value) {
            this.maxAge = value;
            return this;
        }

        public final Builder maxAge(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.maxAge(fn.apply(new Time.Builder()).build());
        }

        public final Builder maxDocs(@Nullable Long value) {
            this.maxDocs = value;
            return this;
        }

        public final Builder maxSize(@Nullable String value) {
            this.maxSize = value;
            return this;
        }

        public final Builder maxSizeBytes(@Nullable String value) {
            this.maxSizeBytes = value;
            return this;
        }

        public final Builder maxPrimaryShardSize(@Nullable String value) {
            this.maxPrimaryShardSize = value;
            return this;
        }

        public final Builder maxPrimaryShardSizeBytes(@Nullable String value) {
            this.maxPrimaryShardSizeBytes = value;
            return this;
        }

        public final Builder maxAgeMillis(@Nullable DateTime value) {
            this.maxAgeMillis = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RolloverConditions build() {
            this._checkSingleUse();
            return new RolloverConditions(this);
        }
    }
}

