/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class PatternReplaceTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    private final String flags;
    private final String pattern;
    private final String replacement;
    public static final JsonpDeserializer<PatternReplaceTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PatternReplaceTokenFilter::setupPatternReplaceTokenFilterDeserializer);

    private PatternReplaceTokenFilter(Builder builder) {
        super(builder);
        this.flags = ApiTypeHelper.requireNonNull(builder.flags, this, "flags");
        this.pattern = ApiTypeHelper.requireNonNull(builder.pattern, this, "pattern");
        this.replacement = ApiTypeHelper.requireNonNull(builder.replacement, this, "replacement");
    }

    public static PatternReplaceTokenFilter of(Function<Builder, ObjectBuilder<PatternReplaceTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.PatternReplace;
    }

    public final String flags() {
        return this.flags;
    }

    public final String pattern() {
        return this.pattern;
    }

    public final String replacement() {
        return this.replacement;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "pattern_replace");
        super.serializeInternal(generator, mapper);
        generator.writeKey("flags");
        generator.write(this.flags);
        generator.writeKey("pattern");
        generator.write(this.pattern);
        generator.writeKey("replacement");
        generator.write(this.replacement);
    }

    protected static void setupPatternReplaceTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::flags, JsonpDeserializer.stringDeserializer(), "flags");
        op.add(Builder::pattern, JsonpDeserializer.stringDeserializer(), "pattern");
        op.add(Builder::replacement, JsonpDeserializer.stringDeserializer(), "replacement");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PatternReplaceTokenFilter> {
        private String flags;
        private String pattern;
        private String replacement;

        public final Builder flags(String value) {
            this.flags = value;
            return this;
        }

        public final Builder pattern(String value) {
            this.pattern = value;
            return this;
        }

        public final Builder replacement(String value) {
            this.replacement = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PatternReplaceTokenFilter build() {
            this._checkSingleUse();
            return new PatternReplaceTokenFilter(this);
        }
    }
}

