/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.config.http.BearerTokenRequestMatcher;
import org.springframework.security.config.http.JwtBeanDefinitionParser;
import org.springframework.security.config.http.OpaqueTokenBeanDefinitionParser;
import org.springframework.security.config.http.StaticAuthenticationManagerResolver;
import org.springframework.security.oauth2.server.resource.web.BearerTokenAuthenticationEntryPoint;
import org.springframework.security.oauth2.server.resource.web.BearerTokenAuthenticationFilter;
import org.springframework.security.oauth2.server.resource.web.DefaultBearerTokenResolver;
import org.springframework.security.oauth2.server.resource.web.access.BearerTokenAccessDeniedHandler;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

final class OAuth2ResourceServerBeanDefinitionParser
implements BeanDefinitionParser {
    static final String AUTHENTICATION_MANAGER_RESOLVER_REF = "authentication-manager-resolver-ref";
    static final String BEARER_TOKEN_RESOLVER_REF = "bearer-token-resolver-ref";
    static final String ENTRY_POINT_REF = "entry-point-ref";
    static final String BEARER_TOKEN_RESOLVER = "bearerTokenResolver";
    static final String AUTHENTICATION_ENTRY_POINT = "authenticationEntryPoint";
    private final BeanReference authenticationManager;
    private final List<BeanReference> authenticationProviders;
    private final Map<BeanDefinition, BeanMetadataElement> entryPoints;
    private final Map<BeanDefinition, BeanMetadataElement> deniedHandlers;
    private final List<BeanDefinition> ignoreCsrfRequestMatchers;
    private final BeanDefinition authenticationEntryPoint = new RootBeanDefinition(BearerTokenAuthenticationEntryPoint.class);
    private final BeanDefinition accessDeniedHandler = new RootBeanDefinition(BearerTokenAccessDeniedHandler.class);

    OAuth2ResourceServerBeanDefinitionParser(BeanReference authenticationManager, List<BeanReference> authenticationProviders, Map<BeanDefinition, BeanMetadataElement> entryPoints, Map<BeanDefinition, BeanMetadataElement> deniedHandlers, List<BeanDefinition> ignoreCsrfRequestMatchers) {
        this.authenticationManager = authenticationManager;
        this.authenticationProviders = authenticationProviders;
        this.entryPoints = entryPoints;
        this.deniedHandlers = deniedHandlers;
        this.ignoreCsrfRequestMatchers = ignoreCsrfRequestMatchers;
    }

    public BeanDefinition parse(Element oauth2ResourceServer, ParserContext pc) {
        Element jwt = DomUtils.getChildElementByTagName((Element)oauth2ResourceServer, (String)"jwt");
        Element opaqueToken = DomUtils.getChildElementByTagName((Element)oauth2ResourceServer, (String)"opaque-token");
        this.validateConfiguration(oauth2ResourceServer, jwt, opaqueToken, pc);
        if (jwt != null) {
            BeanDefinition jwtAuthenticationProvider = new JwtBeanDefinitionParser().parse(jwt, pc);
            this.authenticationProviders.add((BeanReference)new RuntimeBeanReference(pc.getReaderContext().registerWithGeneratedName(jwtAuthenticationProvider)));
        }
        if (opaqueToken != null) {
            BeanDefinition opaqueTokenAuthenticationProvider = new OpaqueTokenBeanDefinitionParser().parse(opaqueToken, pc);
            this.authenticationProviders.add((BeanReference)new RuntimeBeanReference(pc.getReaderContext().registerWithGeneratedName(opaqueTokenAuthenticationProvider)));
        }
        BeanMetadataElement bearerTokenResolver = this.getBearerTokenResolver(oauth2ResourceServer);
        BeanDefinitionBuilder requestMatcherBuilder = BeanDefinitionBuilder.rootBeanDefinition(BearerTokenRequestMatcher.class);
        requestMatcherBuilder.addConstructorArgValue((Object)bearerTokenResolver);
        AbstractBeanDefinition requestMatcher = requestMatcherBuilder.getBeanDefinition();
        BeanMetadataElement authenticationEntryPoint = this.getEntryPoint(oauth2ResourceServer);
        this.entryPoints.put((BeanDefinition)requestMatcher, authenticationEntryPoint);
        this.deniedHandlers.put((BeanDefinition)requestMatcher, (BeanMetadataElement)this.accessDeniedHandler);
        this.ignoreCsrfRequestMatchers.add((BeanDefinition)requestMatcher);
        BeanDefinitionBuilder filterBuilder = BeanDefinitionBuilder.rootBeanDefinition(BearerTokenAuthenticationFilter.class);
        BeanMetadataElement authenticationManagerResolver = this.getAuthenticationManagerResolver(oauth2ResourceServer);
        filterBuilder.addConstructorArgValue((Object)authenticationManagerResolver);
        filterBuilder.addPropertyValue(BEARER_TOKEN_RESOLVER, (Object)bearerTokenResolver);
        filterBuilder.addPropertyValue(AUTHENTICATION_ENTRY_POINT, (Object)authenticationEntryPoint);
        return filterBuilder.getBeanDefinition();
    }

    void validateConfiguration(Element oauth2ResourceServer, Element jwt, Element opaqueToken, ParserContext pc) {
        if (!oauth2ResourceServer.hasAttribute(AUTHENTICATION_MANAGER_RESOLVER_REF)) {
            if (jwt == null && opaqueToken == null) {
                pc.getReaderContext().error("Didn't find authentication-manager-resolver-ref, <jwt>, or <opaque-token>. Please select one.", (Object)oauth2ResourceServer);
            }
            return;
        }
        if (jwt != null) {
            pc.getReaderContext().error("Found <jwt> as well as authentication-manager-resolver-ref. Please select just one.", (Object)oauth2ResourceServer);
        }
        if (opaqueToken != null) {
            pc.getReaderContext().error("Found <opaque-token> as well as authentication-manager-resolver-ref. Please select just one.", (Object)oauth2ResourceServer);
        }
    }

    BeanMetadataElement getAuthenticationManagerResolver(Element element) {
        String authenticationManagerResolverRef = element.getAttribute(AUTHENTICATION_MANAGER_RESOLVER_REF);
        if (!StringUtils.isEmpty((Object)authenticationManagerResolverRef)) {
            return new RuntimeBeanReference(authenticationManagerResolverRef);
        }
        BeanDefinitionBuilder authenticationManagerResolver = BeanDefinitionBuilder.rootBeanDefinition(StaticAuthenticationManagerResolver.class);
        authenticationManagerResolver.addConstructorArgValue((Object)this.authenticationManager);
        return authenticationManagerResolver.getBeanDefinition();
    }

    BeanMetadataElement getBearerTokenResolver(Element element) {
        String bearerTokenResolverRef = element.getAttribute(BEARER_TOKEN_RESOLVER_REF);
        if (StringUtils.isEmpty((Object)bearerTokenResolverRef)) {
            return new RootBeanDefinition(DefaultBearerTokenResolver.class);
        }
        return new RuntimeBeanReference(bearerTokenResolverRef);
    }

    BeanMetadataElement getEntryPoint(Element element) {
        String entryPointRef = element.getAttribute(ENTRY_POINT_REF);
        if (StringUtils.isEmpty((Object)entryPointRef)) {
            return this.authenticationEntryPoint;
        }
        return new RuntimeBeanReference(entryPointRef);
    }
}

