/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.hystrix.command;

import com.netflix.hystrix.HystrixObservableCommand;
import java.net.URI;
import org.apache.shenyu.common.utils.UriUtils;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.hystrix.command.Command;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import rx.Observable;
import rx.RxReactiveStreams;

public class HystrixCommand
extends HystrixObservableCommand<Void>
implements Command {
    private static final Logger LOG = LoggerFactory.getLogger(HystrixCommand.class);
    private final ServerWebExchange exchange;
    private final ShenyuPluginChain chain;
    private final URI callBackUri;

    public HystrixCommand(HystrixObservableCommand.Setter setter, ServerWebExchange exchange, ShenyuPluginChain chain, String callBackUri) {
        super(setter);
        this.exchange = exchange;
        this.chain = chain;
        this.callBackUri = UriUtils.createUri((String)callBackUri);
    }

    protected Observable<Void> construct() {
        return RxReactiveStreams.toObservable((Publisher)this.chain.execute(this.exchange));
    }

    protected Observable<Void> resumeWithFallback() {
        return RxReactiveStreams.toObservable(this.doFallback());
    }

    private Mono<Void> doFallback() {
        if (this.isFailedExecution()) {
            LOG.error("hystrix execute have error: ", this.getExecutionException());
        }
        Throwable exception = this.getExecutionException();
        return this.doFallback(this.exchange, exception);
    }

    @Override
    public Observable<Void> fetchObservable() {
        return this.toObservable();
    }

    @Override
    public URI getCallBackUri() {
        return this.callBackUri;
    }

    @Override
    public void removeCommandKey(String commandKey) {
        executionSemaphorePerCircuit.remove(commandKey);
    }

    @Override
    public void cleanCommand() {
        executionSemaphorePerCircuit.clear();
    }
}

