/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.hystrix;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.HystrixHandle;
import org.apache.shenyu.common.enums.HystrixIsolationModeEnum;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.ResultEnum;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.hystrix.builder.HystrixBuilder;
import org.apache.shenyu.plugin.hystrix.command.Command;
import org.apache.shenyu.plugin.hystrix.command.HystrixCommand;
import org.apache.shenyu.plugin.hystrix.command.HystrixCommandOnThread;
import org.apache.shenyu.plugin.hystrix.handler.HystrixPluginDataHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import rx.Subscription;

public class HystrixPlugin
extends AbstractShenyuPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(HystrixPlugin.class);

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        ShenyuContext shenyuContext = (ShenyuContext)exchange.getAttribute("context");
        assert (shenyuContext != null);
        HystrixHandle hystrixHandle = (HystrixHandle)HystrixPluginDataHandler.CACHED_HANDLE.get().obtainHandle((Object)CacheKeyUtils.INST.getKey(rule));
        String groupKey = hystrixHandle.getGroupKey();
        if (StringUtils.isBlank((CharSequence)hystrixHandle.getGroupKey())) {
            groupKey = Objects.requireNonNull(shenyuContext).getModule();
        }
        String commandKey = hystrixHandle.getCommandKey();
        if (StringUtils.isBlank((CharSequence)hystrixHandle.getCommandKey())) {
            commandKey = Objects.requireNonNull(shenyuContext).getMethod();
        }
        Command command = this.fetchCommand(hystrixHandle, exchange, chain, commandKey, groupKey);
        return Mono.create(s -> {
            Subscription sub = command.fetchObservable().subscribe(arg_0 -> ((MonoSink)s).success(arg_0), arg_0 -> ((MonoSink)s).error(arg_0), () -> ((MonoSink)s).success());
            s.onCancel(() -> ((Subscription)sub).unsubscribe());
            if (command.isCircuitBreakerOpen()) {
                LOG.error("hystrix execute have circuitBreaker is Open! groupKey:{},commandKey:{}", (Object)hystrixHandle.getGroupKey(), (Object)hystrixHandle.getCommandKey());
            }
        }).doOnError(throwable -> {
            LOG.error("hystrix execute exception:", throwable);
            exchange.getAttributes().put("webHandlerClientResponseResultType", ResultEnum.ERROR.getName());
            chain.execute(exchange);
        }).then();
    }

    private Command fetchCommand(HystrixHandle hystrixHandle, ServerWebExchange exchange, ShenyuPluginChain chain, String commandKey, String groupKey) {
        if (hystrixHandle.getExecutionIsolationStrategy() == HystrixIsolationModeEnum.SEMAPHORE.getCode()) {
            return new HystrixCommand(HystrixBuilder.build(hystrixHandle, commandKey, groupKey), exchange, chain, hystrixHandle.getCallBackUri());
        }
        return new HystrixCommandOnThread(HystrixBuilder.buildForHystrixCommand(hystrixHandle, commandKey, groupKey), exchange, chain, hystrixHandle.getCallBackUri());
    }

    public String named() {
        return PluginEnum.HYSTRIX.getName();
    }

    public int getOrder() {
        return PluginEnum.HYSTRIX.getCode();
    }
}

