/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.mock.generator;

import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.shenyu.plugin.mock.generator.Generator;
import org.apache.shenyu.spi.Join;

@Join
public class ZhStringGenerator
implements Generator<String> {
    private int min;
    private int max;

    @Override
    public String getName() {
        return "zh";
    }

    @Override
    public String generate() {
        Random random = new Random();
        int len = random.nextInt(this.max - this.min - 1) + this.min;
        return RandomStringUtils.random((int)len, (int)19968, (int)40869, (boolean)false, (boolean)false);
    }

    @Override
    public int getParamSize() {
        return 1;
    }

    @Override
    public void initParam(List<String> params, String rule) {
        String[] range = params.get(0).split("-");
        this.min = Integer.parseInt(range[0]);
        this.max = Integer.parseInt(range[1]);
    }

    @Override
    public boolean match(String rule) {
        return rule.matches("^zh\\|\\d+-\\d+$");
    }

    @Override
    public String[] getPrefixAndSuffix() {
        return new String[]{"\"", "\""};
    }
}

