/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.mock.generator;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.shenyu.plugin.mock.generator.Generator;
import org.apache.shenyu.plugin.mock.util.RandomUtil;
import org.apache.shenyu.spi.Join;

@Join
public class RangeDataGenerator
implements Generator<String> {
    private List<String> data;

    @Override
    public String getName() {
        return "list";
    }

    @Override
    public String generate() {
        return this.data.get(RandomUtil.randomInt(0, this.data.size() - 1));
    }

    @Override
    public int getParamSize() {
        return 0;
    }

    @Override
    public void initParam(List<String> params, String rule) {
        String rangeData = params.get(0).replaceAll("\\[(.+)]", "$1");
        this.data = Arrays.stream(rangeData.split("(?<!\\\\),")).map(data -> data.replace("\\,", ",")).collect(Collectors.toList());
    }

    @Override
    public boolean match(String rule) {
        boolean matches = rule.matches("^list\\|\\[.+]$");
        if (matches) {
            String candidateData = rule.substring(6, rule.length() - 1);
            return !candidateData.matches("^\\s+$");
        }
        return false;
    }

    @Override
    public String[] getPrefixAndSuffix() {
        return new String[]{"\"", "\""};
    }
}

