/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.mock.generator;

import java.util.List;
import java.util.Objects;
import org.apache.shenyu.plugin.mock.generator.Generator;
import org.apache.shenyu.spi.Join;

@Join
public class RandomDoubleGenerator
implements Generator<String> {
    private Double min;
    private Double max;
    private String format;

    @Override
    public String getName() {
        return "double";
    }

    @Override
    public String generate() {
        Double result = Math.random() * (this.max - this.min) + this.min;
        if (this.format != null) {
            return String.format(this.format, result);
        }
        return String.valueOf(result);
    }

    @Override
    public int getParamSize() {
        return 1;
    }

    @Override
    public void initParam(List<String> params, String rule) {
        String[] range = params.get(0).split("-");
        this.min = Double.parseDouble(range[0]);
        this.max = Double.parseDouble(range[1]);
        if (params.size() == 2) {
            this.format = Objects.equals(params.get(1), "") ? null : params.get(1);
        }
    }

    @Override
    public boolean match(String rule) {
        return rule.matches("^double\\|\\d+(?:\\.\\d+)?-\\d+(?:\\.\\d+)?.*");
    }

    @Override
    public String[] getPrefixAndSuffix() {
        return new String[]{"\"", "\""};
    }
}

