/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.mock.generator;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shenyu.plugin.mock.generator.Generator;
import org.apache.shenyu.spi.ExtensionLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GeneratorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(GeneratorFactory.class);
    private static final String ERROR_PARSE = "\"[#ERROR EXPRESSION#]\"";
    private static final Pattern RULE_CONTENT_PATTERN = Pattern.compile("^\\$\\{(.+?)}$", 8);

    private GeneratorFactory() {
    }

    public static Generator<?> newInstance(String ruleName, String rule) {
        try {
            return (Generator)ExtensionLoader.getExtensionLoader(Generator.class).getJoin(ruleName);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("{} can not parse,please check", (Object)rule);
            return null;
        }
    }

    private static String generate(String rule) {
        Matcher matcher = RULE_CONTENT_PATTERN.matcher(rule);
        if (matcher.find()) {
            String ruleContent = matcher.group(1);
            String ruleName = ruleContent.split("\\|")[0];
            Generator<?> generator = GeneratorFactory.newInstance(ruleName, rule);
            if (generator == null || !generator.match(ruleContent)) {
                return rule;
            }
            String[] prefixAndSuffix = generator.getPrefixAndSuffix();
            generator.parseRule(ruleContent);
            Object generateData = generator.generate();
            return String.join((CharSequence)"", prefixAndSuffix[0], generateData.toString(), prefixAndSuffix[1]);
        }
        return rule;
    }

    public static String dealRule(String content) {
        String afterDeal = content;
        String placeHolder = GeneratorFactory.getPlaceholder(content);
        while (placeHolder != null) {
            String generateData = GeneratorFactory.generate(placeHolder);
            if (Objects.equals(generateData, placeHolder)) {
                generateData = ERROR_PARSE;
            }
            String toString = String.valueOf(generateData);
            placeHolder = placeHolder.replaceAll("([$|{}\\]\\[])", "\\\\$1");
            afterDeal = afterDeal.replaceFirst(placeHolder, toString);
            placeHolder = GeneratorFactory.getPlaceholder(afterDeal);
        }
        return afterDeal;
    }

    private static String getPlaceholder(String rule) {
        int start = rule.indexOf("${");
        if (start < 0) {
            return null;
        }
        int counter = 1;
        for (int i = start + 2; i < rule.length(); ++i) {
            char c = rule.charAt(i);
            if (c == '{') {
                ++counter;
                continue;
            }
            if (c != '}' || --counter != 0) continue;
            return "${" + rule.substring(start + 2, i) + "}";
        }
        return null;
    }
}

