/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.mock.generator;

import org.apache.shenyu.plugin.mock.generator.Generator;
import org.apache.shenyu.plugin.mock.util.RandomUtil;
import org.apache.shenyu.spi.Join;

@Join
public class EmailGenerator
implements Generator<String> {
    private static final String[] DOMAIN_SUFFIX = new String[]{"com", "org", "cn", "com.cn", "top", "edu", "io"};

    @Override
    public String getName() {
        return "email";
    }

    @Override
    public String generate() {
        return String.format("%s@%s.%s", RandomUtil.randomLowerLetterString(RandomUtil.randomInt(5, 10)), RandomUtil.randomLowerLetterString(RandomUtil.randomInt(3, 8)), DOMAIN_SUFFIX[RandomUtil.randomInt(0, DOMAIN_SUFFIX.length - 1)]);
    }

    @Override
    public int getParamSize() {
        return 0;
    }

    @Override
    public boolean match(String rule) {
        return rule.matches("^email$");
    }

    @Override
    public String[] getPrefixAndSuffix() {
        return new String[]{"\"", "\""};
    }
}

