/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.mock.generator;

import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.apache.shenyu.plugin.mock.generator.Generator;
import org.apache.shenyu.spi.Join;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Join
public class CurrentTimeGenerator
implements Generator<String> {
    private static final String DEFAULT_FORMAT = "YYYY-MM-dd HH:mm:ss";
    private static final Logger LOG = LoggerFactory.getLogger(CurrentTimeGenerator.class);
    private String format;

    @Override
    public String getName() {
        return "current";
    }

    @Override
    public String generate() {
        LocalDateTime now = LocalDateTime.now();
        try {
            return DateTimeFormatter.ofPattern(this.format).format(now);
        }
        catch (DateTimeException e) {
            LOG.warn("format fail,use default format :{}", (Object)DEFAULT_FORMAT);
            return DateTimeFormatter.ofPattern(DEFAULT_FORMAT).format(now);
        }
    }

    @Override
    public int getParamSize() {
        return 0;
    }

    @Override
    public void initParam(List<String> params, String rule) {
        this.format = params.size() >= 1 ? params.get(0) : DEFAULT_FORMAT;
    }

    @Override
    public boolean match(String rule) {
        return rule.matches("^current(\\|.+)?");
    }

    @Override
    public String[] getPrefixAndSuffix() {
        return new String[]{"\"", "\""};
    }
}

