/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.mock.generator;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.shenyu.plugin.mock.generator.Generator;
import org.apache.shenyu.plugin.mock.generator.GeneratorFactory;
import org.apache.shenyu.spi.Join;

@Join
public class ArrayGenerator
implements Generator<String> {
    private Integer length;
    private String repeatContent;

    @Override
    public String getName() {
        return "array";
    }

    @Override
    public String generate() {
        String replaceContentCopy = this.repeatContent;
        return IntStream.rangeClosed(0, this.length - 1).mapToObj(i -> GeneratorFactory.dealRule(replaceContentCopy)).collect(Collectors.joining(","));
    }

    @Override
    public int getParamSize() {
        return 0;
    }

    @Override
    public void initParam(List<String> params, String rule) {
        this.length = Integer.parseInt(rule.substring(rule.lastIndexOf("|") + 1));
        this.repeatContent = rule.substring(rule.indexOf("|") + 1, rule.lastIndexOf("|"));
    }

    @Override
    public boolean match(String rule) {
        return rule.matches("^array\\|.+\\|\\d+$");
    }

    @Override
    public String[] getPrefixAndSuffix() {
        return new String[]{"[", "]"};
    }
}

